/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.lang.reflect.Field;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public class Hacks {
    static final boolean NAMED_ENV = CoreAPI.isNamedEnv();
    static final boolean SRG_ENV = CoreAPI.isSrgEnv();
    static final int JAVA_VERSION = CoreAPI.javaVersion();

    @IndirectCallers
    public static <T> T construct(String targetClass, Object ... args) {
        return Hacks.construct(Hacks.findClass(targetClass), args);
    }

    @IndirectCallers
    public static <T> T construct(Class<?> reference, String targetClass, Object ... args) {
        return Hacks.construct(Hacks.findClass(reference, targetClass), args);
    }

    public static <T> T construct(Class<?> target, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call construct on null target class! (args = {})", args);
            return null;
        }
        return StaticComponentContainer.Constructors.newInstanceOf(target, args);
    }

    @IndirectCallers
    public static <T> T constructDirect(String targetClass, Object ... args) {
        return Hacks.constructDirect(Hacks.findClass(targetClass), args);
    }

    @IndirectCallers
    public static <T> T constructDirect(Class<?> reference, String targetClass, Object ... args) {
        return Hacks.constructDirect(Hacks.findClass(reference, targetClass), args);
    }

    public static <T> T constructDirect(Class<?> target, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call constructDirect on null target class! (args = {})", args);
            return null;
        }
        return StaticComponentContainer.Constructors.newInstanceOf(target, args);
    }

    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> defaultCaller() {
        return StaticComponentContainer.Classes.getClass();
    }

    @Nullable
    public static Class<?> findClass(String target, ClassLoader loader, Class<?> caller, boolean initialize) {
        if (Misc.anyNull(target, loader, caller)) {
            TILRef.logError("Cannot find target class {} on {} with caller {}!", target, loader, caller);
            return null;
        }
        try {
            return StaticComponentContainer.Driver.getClassByName(target, initialize, loader, caller);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to find class {} on loader {} with caller {}! (initialize={})", target, loader, caller, initialize, t);
            return null;
        }
    }

    @Nullable
    public static Class<?> findClass(String target, Class<?> caller, boolean initialize) {
        return Objects.nonNull(caller) ? Hacks.findClass(target, Hacks.contextClassLoader(), caller, initialize) : Hacks.findClass(target, initialize);
    }

    @Nullable
    public static Class<?> findClass(String target, Class<?> caller) {
        return Hacks.findClass(target, caller, false);
    }

    @Nullable
    public static Class<?> findClass(String target, ClassLoader loader, Class<?> caller) {
        return Hacks.findClass(target, loader, caller, false);
    }

    @Nullable
    public static Class<?> findClass(String target, ClassLoader loader, boolean initialize) {
        return Objects.nonNull(loader) ? Hacks.findClass(target, loader, Hacks.defaultCaller(), initialize) : Hacks.findClass(target, initialize);
    }

    @Nullable
    public static Class<?> findClass(String target, ClassLoader loader) {
        return Hacks.findClass(target, loader, false);
    }

    @Nullable
    public static Class<?> findClass(String target, boolean initialize) {
        return Hacks.findClass(target, Hacks.contextClassLoader(), Hacks.defaultCaller(), initialize);
    }

    @Nullable
    public static Class<?> findClass(String target) {
        return Hacks.findClass(target, false);
    }

    @Nullable
    public static Class<?> findClass(@Nullable Class<?> reference, String target) {
        if (Objects.isNull(reference)) {
            return Hacks.findClass(target);
        }
        return Hacks.findClass(reference.getPackage().getName() + "." + target, reference.getClassLoader());
    }

    @Nullable
    public static Class<?> findClass(@Nullable Package pkg, String target) {
        return Objects.nonNull(pkg) ? Hacks.findClass(pkg.getName(), target) : Hacks.findClass(target);
    }

    @Nullable
    public static Class<?> findClass(@Nullable String pkg, String target) {
        return Objects.nonNull(pkg) ? Hacks.findClass(pkg + "." + target) : Hacks.findClass(target);
    }

    @IndirectCallers
    public static <T> T getField(Object target, String named, String intermediary) {
        return Hacks.getField(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    public static <T> T getField(Object target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call getField on null target object! (field = {})", field);
            return null;
        }
        if (Objects.isNull(field)) {
            TILRef.logError("Tried to call getField with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.get(target, field);
    }

    @IndirectCallers
    public static <T> T getFieldDirect(Object target, String named, String intermediary) {
        return Hacks.getFieldDirect(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    @IndirectCallers
    public static <T> T getFieldDirect(Object target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call getFieldDirect on null target object! (field = {})", field);
            return null;
        }
        if (Objects.isNull(field)) {
            TILRef.logError("Tried to call getFieldDirect with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getDirect(target, field);
    }

    @IndirectCallers
    public static <T> T getFieldStatic(String targetClass, String named, String intermediary) {
        return Hacks.getFieldStatic(Hacks.findClass(targetClass), named, intermediary);
    }

    public static <T> T getFieldStatic(Class<?> target, String named, String intermediary) {
        return Hacks.getFieldStatic(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    @IndirectCallers
    public static <T> T getFieldStatic(String targetClass, String field) {
        return Hacks.getFieldStatic(Hacks.findClass(targetClass), field);
    }

    public static <T> T getFieldStatic(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call getFieldStatic on null target class! (field = {})", field);
            return null;
        }
        if (Objects.isNull(field)) {
            TILRef.logError("Tried to call getFieldStatic with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getStatic(target, field);
    }

    @IndirectCallers
    public static <T> T getFieldStaticDirect(String targetClass, String named, String intermediary) {
        return Hacks.getFieldStaticDirect(Hacks.findClass(targetClass), named, intermediary);
    }

    public static <T> T getFieldStaticDirect(Class<?> target, String named, String intermediary) {
        return Hacks.getFieldStaticDirect(target, Hacks.isNamedEnv() ? named : intermediary);
    }

    @IndirectCallers
    public static <T> T getFieldStaticDirect(String targetClass, String field) {
        return Hacks.getFieldStaticDirect(Hacks.findClass(targetClass), field);
    }

    public static <T> T getFieldStaticDirect(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call getFieldStaticDirect on null target class! (field = {})", field);
            return null;
        }
        if (Objects.isNull(field)) {
            TILRef.logError("Tried to call getFieldStaticDirect with null field name! (target = {})", target);
            return null;
        }
        return StaticComponentContainer.Fields.getStaticDirect(target, field);
    }

    @IndirectCallers
    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    private static Object getRecordComponent(Class<?> target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to get record component of null class target! (field = {})", field);
            return null;
        }
        if (Objects.isNull(field)) {
            TILRef.logError("Tried to get record component for null field name! (target = {})", target);
            return null;
        }
        if (Hacks.isJava8()) {
            TILRef.logError("Cannot get record component in Java 8 environment! Records were introduced in Java 14! ({}.{})", target.getName(), field);
            return null;
        }
        Object[] components = (Object[])Hacks.invoke(target, "getRecordComponents", new Object[0]);
        if (Objects.isNull(components)) {
            TILRef.logError("No record components found in target {}!", target);
            return null;
        }
        for (Object component : components) {
            if (!field.equals(Hacks.invoke(component, "getName", new Object[0]))) continue;
            return component;
        }
        TILRef.logError("No record components matching '{}' found in target {}!", field, target);
        return null;
    }

    public static <T> T getRecordField(Object target, String field) {
        if (Objects.isNull(target)) {
            TILRef.logError("Cannot get record field {} from null object target!", field);
            return null;
        }
        Class<?> targetClass = target.getClass();
        return Hacks.getRecordFieldInstance(targetClass, target, field, Hacks.getRecordComponent(targetClass, field));
    }

    private static <T> T getRecordFieldInstance(Class<?> targetClass, @Nullable Object target, String name, @Nullable Object component) {
        if (Objects.isNull(component)) {
            TILRef.logError("Failed to get record component for target {}! (field = {})", targetClass, name);
            return null;
        }
        try {
            Field field = StaticComponentContainer.Classes.getDeclaredField(targetClass, f -> name.equals(f.getName()));
            if (Objects.isNull(field)) {
                TILRef.logError("Found null field {} for class {}", name, targetClass.getName());
                return null;
            }
            StaticComponentContainer.Driver.setAccessible(field, true);
            return (T)field.get(target);
        }
        catch (Throwable t) {
            TILRef.logError("Failed to find field {} in target {}!", name, targetClass, t);
            return null;
        }
    }

    @IndirectCallers
    public static <T> T getRecordFieldStatic(Class<?> target, String field) {
        return Hacks.getRecordFieldInstance(target, null, field, Hacks.getRecordComponent(target, field));
    }

    @IndirectCallers
    public static <T> T invoke(Object target, String named, String intermediary, Object ... args) {
        return Hacks.invoke(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    public static <T> T invoke(Object target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call invoke on null target object! (method = {} | args = {})", method, args);
            return null;
        }
        if (Objects.isNull(method)) {
            TILRef.logError("Tried to call invoke with null method name! (target = {} | args = {})", target, args);
            return null;
        }
        return StaticComponentContainer.Methods.invoke(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeDirect(Object target, String named, String intermediary, Object ... args) {
        return Hacks.invokeDirect(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    public static <T> T invokeDirect(Object target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call invokeDirect on null target object! (method = {} | args = {})", method, args);
            return null;
        }
        if (Objects.isNull(method)) {
            TILRef.logError("Tried to call invokeDirect with null method name! (target = {} | args = {})", target, args);
            return null;
        }
        return StaticComponentContainer.Methods.invoke(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStatic(String targetClass, String named, String intermediary, Object ... args) {
        return Hacks.invokeStatic(Hacks.findClass(targetClass), named, intermediary, args);
    }

    public static <T> T invokeStatic(Class<?> target, String named, String intermediary, Object ... args) {
        return Hacks.invokeStatic(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    @IndirectCallers
    public static <T> T invokeStatic(String targetClass, String method, Object ... args) {
        return Hacks.invokeStatic(Hacks.findClass(targetClass), method, args);
    }

    public static <T> T invokeStatic(Class<?> target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call invokeStatic on null target object! (method = {} | args = {})", method, args);
            return null;
        }
        if (Objects.isNull(method)) {
            TILRef.logError("Tried to call invokeStatic with null method name! (target = {} | args = {})", target, args);
            return null;
        }
        return StaticComponentContainer.Methods.invokeStatic(target, method, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticDirect(String targetClass, String named, String intermediary, Object ... args) {
        return Hacks.invokeStaticDirect(Hacks.findClass(targetClass), named, intermediary, args);
    }

    public static <T> T invokeStaticDirect(Class<?> target, String named, String intermediary, Object ... args) {
        return Hacks.invokeStaticDirect(target, Hacks.isNamedEnv() ? named : intermediary, args);
    }

    @IndirectCallers
    public static <T> T invokeStaticDirect(String targetClass, String method, Object ... args) {
        return Hacks.invokeStaticDirect(Hacks.findClass(targetClass), method, args);
    }

    public static <T> T invokeStaticDirect(Class<?> target, String method, Object ... args) {
        if (Objects.isNull(target)) {
            TILRef.logError("Tried to call invokeStaticDirect on null target object! (method = {} | args = {})", method, args);
            return null;
        }
        if (Objects.isNull(method)) {
            TILRef.logError("Tried to call invokeStaticDirect with null method name! (target = {} | args = {})", target, args);
            return null;
        }
        return StaticComponentContainer.Methods.invokeStaticDirect(target, method, args);
    }

    public static boolean isJava8() {
        return JAVA_VERSION == 8;
    }

    @IndirectCallers
    public static boolean isJava17() {
        return JAVA_VERSION == 17;
    }

    @IndirectCallers
    public static boolean isJava21() {
        return JAVA_VERSION >= 21;
    }

    public static boolean isNamedEnv() {
        return NAMED_ENV;
    }

    @IndirectCallers
    public static boolean isSrgEnv() {
        return SRG_ENV;
    }
}

