/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.structure;

import java.util.Objects;
import java.util.StringJoiner;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;

public abstract class StructureAPI<S>
extends AbstractWrapped<S> {
    protected StructureAPI(S structure) {
        super(structure);
    }

    @IndirectCallers
    public String getName() {
        ResourceLocationAPI<?> registryName = this.getRegistryName();
        if (Objects.isNull(registryName)) {
            return null;
        }
        String[] words = registryName.getPath().split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(TextHelper.capitalize(word));
        }
        return joiner.toString();
    }

    @IndirectCallers
    public String getName(WorldAPI<?> world) {
        ResourceLocationAPI<?> registryName = this.getRegistryName(world);
        if (Objects.isNull(registryName)) {
            return null;
        }
        String[] words = registryName.getPath().split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(TextHelper.capitalize(word));
        }
        return joiner.toString();
    }

    public abstract ResourceLocationAPI<?> getRegistryName();

    public ResourceLocationAPI<?> getRegistryName(WorldAPI<?> world) {
        return this.getRegistryName();
    }
}

