/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.item;

import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.Hand;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.PosHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import org.jetbrains.annotations.Nullable;

public class TILItemUseContext {
    private final PlayerAPI<?, ?> player;
    private final WorldAPI<?> world;
    private final BlockPosAPI<?> pos;
    private final BlockStateAPI<?> state;
    private final Hand hand;
    private final Facing facing;
    private ActionResult superResult = ActionResult.PASS;

    public static TILItemUseContext wrap(Object player, Object world, Object pos, Object state, Object hand, Object facing) {
        return new TILItemUseContext(WrapperHelper.wrapPlayer(player), WrapperHelper.wrapWorld(world), PosHelper.getPos(pos), WrapperHelper.wrapState(state), EventHelper.getHand(hand), EventHelper.getFacing(facing));
    }

    public TILItemUseContext(PlayerAPI<?, ?> player, WorldAPI<?> world, BlockPosAPI<?> pos, BlockStateAPI<?> state, Hand hand, Facing facing) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.hand = hand;
        this.facing = facing;
    }

    @IndirectCallers
    public ActionResult onUse(@Nullable Function<TILItemUseContext, ActionResult> onUse) {
        return Objects.nonNull(onUse) ? onUse.apply(this) : ActionResult.PASS;
    }

    @Generated
    public PlayerAPI<?, ?> getPlayer() {
        return this.player;
    }

    @Generated
    public WorldAPI<?> getWorld() {
        return this.world;
    }

    @Generated
    public BlockPosAPI<?> getPos() {
        return this.pos;
    }

    @Generated
    public BlockStateAPI<?> getState() {
        return this.state;
    }

    @Generated
    public Hand getHand() {
        return this.hand;
    }

    @Generated
    public Facing getFacing() {
        return this.facing;
    }

    @Generated
    public ActionResult getSuperResult() {
        return this.superResult;
    }

    @Generated
    public void setSuperResult(ActionResult superResult) {
        this.superResult = superResult;
    }
}

