/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.entity;

import java.util.UUID;
import mods.thecomputerizer.theimpossiblelibrary.api.common.container.PlayerInventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.Hand;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerAPI<P, V>
extends LivingEntityAPI<P, V> {
    protected PlayerAPI(P entity, V type) {
        super(entity, type);
    }

    @IndirectCallers
    public abstract int getAir();

    @IndirectCallers
    public abstract BlockPosAPI<?> getBedPos(DimensionAPI<?> var1);

    public abstract int getGamemodeOrdinal();

    public abstract PlayerInventoryAPI<?> getInventory();

    public abstract ItemStackAPI<?> getMainHandStack();

    public abstract ItemStackAPI<?> getOffHandStack();

    public ItemStackAPI<?> getStackInHand(Hand hand) {
        return hand == Hand.MAINHAND ? this.getMainHandStack() : this.getOffHandStack();
    }

    public abstract UUID getUUID();

    @IndirectCallers
    public abstract boolean isClientPlayer();

    @IndirectCallers
    public abstract boolean isFishing();

    @IndirectCallers
    public abstract boolean isFlying();

    @IndirectCallers
    public boolean isGamemodeAdventure() {
        return this.getGamemodeOrdinal() == 2;
    }

    @IndirectCallers
    public boolean isGamemodeCreative() {
        return this.getGamemodeOrdinal() == 1;
    }

    @IndirectCallers
    public boolean isGamemodeSpectator() {
        return this.getGamemodeOrdinal() == 3;
    }

    @IndirectCallers
    public boolean isGamemodeSurvival() {
        return this.getGamemodeOrdinal() == 0;
    }

    @IndirectCallers
    public void sendMessage(TextAPI<?> text) {
        this.sendMessage(text, null);
    }

    public abstract void sendMessage(TextAPI<?> var1, @Nullable UUID var2);

    public abstract void sendStatusMessage(TextAPI<?> var1, boolean var2);
}

