/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryEntryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.block.BlockBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;

public abstract class BlockEntityAPI<E, T>
extends AbstractWrapped<T>
implements RegistryEntryAPI<T> {
    protected final E entity;
    protected ResourceLocationAPI<?> registryName;
    protected BlockBuilderAPI.BlockEntityCreator creator;

    protected BlockEntityAPI(E entity, T type) {
        super(type);
        this.entity = entity;
        if (Objects.nonNull(this.entity)) {
            this.creator = (world, pos, state) -> this;
        }
    }

    @IndirectCallers
    public BlockEntityAPI<?, ?> createFromReference(WorldAPI<?> world, BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        return Objects.nonNull(this.creator) ? this.creator.create(world, pos, state) : null;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof BlockEntityAPI) {
            E entity = this.getEntity();
            E otherEntity = ((BlockEntityAPI)other).getEntity();
            return Objects.isNull(otherEntity) ? Objects.isNull(entity) : entity.equals(otherEntity);
        }
        return false;
    }

    public abstract BlockPosAPI<?> getPos();

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        RegistryAPI<?> registry;
        if (Objects.isNull(this.registryName) && Objects.nonNull(this.wrapped) && Objects.nonNull(registry = this.getRegistry())) {
            this.registryName = registry.getKey(this.unwrap());
        }
        return this.registryName;
    }

    public BlockStateAPI<?> getState() {
        WorldAPI<?> world = this.getWorld();
        return Objects.nonNull(world) ? world.getStateAt(this.getPos()) : null;
    }

    public abstract WorldAPI<?> getWorld();

    @IndirectCallers
    public abstract CompoundTagAPI<?> readTagFrom();

    protected void setLocalRegistryName(ResourceLocationAPI<?> registryName) {
        this.registryName = registryName;
    }

    @IndirectCallers
    public abstract void writeTagTo(CompoundTagAPI<?> var1);

    @Generated
    public E getEntity() {
        return this.entity;
    }

    @Generated
    public BlockBuilderAPI.BlockEntityCreator getCreator() {
        return this.creator;
    }

    @Generated
    public void setCreator(BlockBuilderAPI.BlockEntityCreator creator) {
        this.creator = creator;
    }
}

