/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.biome;

import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryEntryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;

public abstract class BiomeAPI<B>
extends AbstractWrapped<B>
implements RegistryEntryAPI<B> {
    protected ResourceLocationAPI<?> registryName;

    protected BiomeAPI(B biome) {
        super(biome);
    }

    @IndirectCallers
    public boolean canRain(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return TILRef.getCommonHandles().canBiomeRain(this.wrapped, world, pos);
    }

    @IndirectCallers
    public boolean canSnow(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return TILRef.getCommonHandles().canBiomeSnow(this.wrapped, world, pos);
    }

    @IndirectCallers
    public abstract float getRainfall();

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        RegistryAPI<?> registry;
        if (Objects.isNull(this.registryName) && Objects.nonNull(this.wrapped) && Objects.nonNull(registry = this.getRegistry())) {
            this.registryName = registry.getKey(this.unwrap());
        }
        return this.registryName;
    }

    @Override
    @IndirectCallers
    public abstract ResourceLocationAPI<?> getRegistryName(WorldAPI<?> var1);

    @IndirectCallers
    public Set<String> getTagNames(WorldAPI<?> world) {
        return TILRef.getCommonHandles().biomeTagNames(world, this.unwrap());
    }

    @IndirectCallers
    public abstract float getTemperatureAt(BlockPosAPI<?> var1);

    protected void setLocalRegistryName(ResourceLocationAPI<?> registryName) {
        this.registryName = registryName;
    }
}

