/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.test;

import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderableText;
import mods.thecomputerizer.theimpossiblelibrary.api.client.test.TestScreen;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ClientTests {
    public static final KeyAPI<?> TEST_KEY = KeyHelper.create("key.test", String.format("key.categories.%1$s", "theimpossiblelibrary"), KeyAPI.AlphaNum.L);

    public static void runTests() {
        TILRef.logWarn("Running client tests", new Object[0]);
        ClientTests.guiTest();
    }

    private static void renderableTest() {
        try {
            TILDev.logWarn("RENDERABLE TEST", new Object[0]);
            Toml transitions = Toml.readStream(ResourceHelper.getResourceStream(TILRef.res("test/transitions.toml")));
            ClientTests.renderableTitleTest(transitions);
            ClientTests.renderableImageTest(transitions);
        }
        catch (Exception ex) {
            TILRef.logError("Renderable test failed!", ex);
        }
    }

    private static void renderableTitleTest(Toml transitions) {
        TILDev.logWarn("TITLE TEST", new Object[0]);
        RenderHelper.addRenderable(new RenderableText(transitions.getTable("title").parameterizeEntries()));
    }

    private static void renderableImageTest(Toml transitions) {
        TILDev.logWarn("IMAGE TEST", new Object[0]);
        Toml image = transitions.getTable("image");
        RenderHelper.addRenderable(RenderHelper.initPNG(TILRef.res(image.getValueString("name")), image.parameterizeEntries()));
    }

    private static void guiTest() {
        TILDev.logWarn("GUI TEST", new Object[0]);
        ScreenHelper.open(TestScreen::new);
    }
}

