/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderShape;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.jetbrains.annotations.Nullable;

public class TextBuffer {
    public static final RenderShape highlightShape = RenderShape.from((Shape)ShapeHelper.plane(Facing.Axis.Y, 0.01), ColorHelper.WHITE.withAlpha(0.5f));
    private final TextAPI<?> text;
    private final Alignment alignment;
    private final double lineSpacing;
    private final double scaleX;
    private final double scaleY;
    private final double translateX;
    private final double translateY;
    private final RenderShape blinkerShape;
    private ColorCache color;
    private int blinkerPos;
    private boolean blinkerVisible;
    private int highlightStart;
    private int highlightEnd;
    private boolean cached;
    private List<String> lineCache;
    private double widthCache;
    private double heightCache;

    public static Builder getBuilder(TextAPI<?> text) {
        return new Builder(text);
    }

    public static TextBuffer literal(String literal) {
        return new Builder(TextHelper.getLiteral(literal)).build();
    }

    public static Builder literalBuilder(String literal) {
        return new Builder(TextHelper.getLiteral(literal));
    }

    public static TextBuffer of(TextAPI<?> text) {
        return new Builder(text).build();
    }

    public static TextBuffer translated(String key, Object ... args) {
        return new Builder(TextHelper.getTranslated(key, args)).build();
    }

    public static Builder translatedBuilder(String key, Object ... args) {
        return new Builder(TextHelper.getTranslated(key, args));
    }

    private TextBuffer(TextAPI<?> text, Alignment alignment, ColorCache color, double lineSpacing, double scaleX, double scaleY, double translateX, double translateY) {
        this.text = Objects.nonNull(text) ? text : TextHelper.getLiteral(" ");
        this.alignment = Objects.nonNull((Object)alignment) ? alignment : Alignment.CENTER;
        this.color = Objects.nonNull(color) ? color : ColorHelper.WHITE;
        this.lineSpacing = lineSpacing;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.translateX = translateX;
        this.translateY = translateY;
        double fontHeight = RenderHelper.getScaledFontHeight();
        this.blinkerShape = RenderShape.from((Shape)ShapeHelper.plane(Facing.Axis.Y, RenderHelper.getScaledStringWidth("|") / 2.0, fontHeight), ColorHelper.BLACK);
        this.blinkerPos = this.textLength();
        highlightShape.setHeight(fontHeight);
    }

    public void cache(RenderContext ctx, double maxWidth) {
        List<String> lines = ctx.splitLines(this.getText().getApplied(), maxWidth);
        this.heightCache = (double)lines.size() * ctx.getScaledFontHeight() * this.scaleY + (double)Math.max(0, lines.size() - 1) * this.lineSpacing * this.scaleY;
        this.widthCache = lines.size() == 1 ? ctx.getScaledStringWidth(lines.get(0)) : maxWidth;
        this.lineCache = lines;
        this.cached = true;
    }

    public TextBuffer copy() {
        return this.copyToBuilder(this.text).build();
    }

    public TextBuffer copyTo(TextAPI<?> text) {
        return this.copyToBuilder(text).build();
    }

    public Builder copyToBuilder() {
        return this.copyToBuilder(this.text);
    }

    public Builder copyToBuilder(TextAPI<?> text) {
        Builder builder = new Builder(text).setAlignment(this.alignment).setColor(this.color).setLineSpacing(this.lineSpacing).setScale(this.scaleX, this.scaleY).setTranslation(this.translateX, this.translateY);
        builder.blinkerPos = this.blinkerPos;
        builder.blinkerVisible = this.blinkerVisible;
        builder.highlightEnd = this.highlightEnd;
        builder.highlightStart = this.highlightStart;
        return builder;
    }

    public void decrementBlinkerPos() {
        --this.blinkerPos;
    }

    public void decrementHighlight() {
        if (this.highlightEnd <= this.highlightStart) {
            this.highlightEnd = this.blinkerPos;
        }
        this.highlightStart = this.blinkerPos - 1;
    }

    public void draw(RenderContext ctx, Vector3 center, double minX, double minY, double maxX, double maxY) {
        double width = Math.abs(maxX - minX);
        if (!this.cached) {
            this.cache(ctx, width);
        }
        this.draw(ctx, center, this.lineCache, this.highlightStart, this.highlightEnd, minX, minY, width, Math.abs(maxY - minY));
    }

    private void draw(RenderContext ctx, Vector3 center, List<String> lines, int charStart, int charEnd, double left, double bottom, double width, double height) {
        double lineHeight = ctx.getScaledFontHeight();
        double offset = 0.0;
        int start = charStart;
        int end = charEnd;
        int blinker = this.blinkerPos;
        for (String line : lines) {
            int lineLength = line.length();
            this.draw(ctx, center.copy(), line, start, Math.min(charEnd, lineLength), blinker, lineHeight, left, bottom, width, height, offset);
            offset += lineHeight + this.lineSpacing;
            if (start >= 0) {
                start -= lineLength;
            }
            if (end >= 0) {
                end -= lineLength;
            }
            if (blinker < 0) continue;
            blinker -= lineLength;
        }
    }

    private void draw(RenderContext ctx, Vector3 center, String line, int charStart, int charEnd, int blinker, double lineHeight, double left, double bottom, double width, double height, double offset) {
        if (this.isTopAligned()) {
            center.setY(bottom + height);
        } else if (this.isBottomAligned()) {
            center.setY(bottom + lineHeight);
        } else {
            center.setY(bottom + height / 2.0 + lineHeight / 2.0);
        }
        if (this.isLeftAligned()) {
            center.setX(left);
        } else if (this.isRightAligned()) {
            center.setX(left - this.getWidth(ctx, width));
        } else {
            center.setX(left + width / 2.0);
        }
        center.add(this.translateX, this.translateY - offset, 0.0);
        RenderAPI renderer = ctx.getRenderer();
        double scaledX = ctx.withScreenScaledX(center.dX());
        double scaledY = ctx.withScreenScaledY(center.dY());
        if (this.isLeftAligned() || this.isRightAligned()) {
            renderer.drawString(ctx.getFont(), line, (Number)scaledX, (Number)scaledY, this.color.getColorI());
        } else {
            renderer.drawCenteredString(ctx.getFont(), line, (Number)scaledX, (Number)scaledY, this.color.getColorI());
            center.setX(center.dX() - ctx.getScaledStringWidth(line) / 2.0);
        }
        double blinkerX = center.dX();
        center.setY(center.dY() - ctx.getScaledFontHeight() / 2.0);
        if (charStart >= 0 && charStart < charEnd) {
            double highlightWidth = ctx.getScaledStringWidth(line.substring(charStart, charEnd));
            center.setX(center.dX() + highlightWidth / 2.0);
            if (charStart > 0) {
                center.setX(center.dX() + ctx.getScaledStringWidth(line.substring(0, charStart)));
            }
            highlightShape.setWidth(highlightWidth);
            highlightShape.draw(ctx, center);
        }
        if (this.blinkerVisible && blinker >= 0 && blinker <= line.length()) {
            center.setX(blinkerX);
            if (blinker > 0) {
                center.setX(center.dX() + (ctx.getScaledStringWidth(line.substring(0, blinker)) - this.blinkerShape.getWidth() / 2.0));
            }
            this.blinkerShape.draw(ctx, center);
        }
    }

    public void flipBlinkerVisibility() {
        this.blinkerVisible = !this.blinkerVisible;
    }

    public int getCharPos(RenderContext ctx, double x, double y, Vector3 center, double minX, double minY, double maxX, double maxY) {
        return this.cached ? this.getCharPos(ctx, x, y, center, this.lineCache, minX, minY, Math.abs(maxX - minX), Math.abs(maxY - minY)) : -1;
    }

    private int getCharPos(RenderContext ctx, double x, double y, Vector3 center, List<String> lines, double left, double bottom, double width, double height) {
        int pos = -1;
        double lineHeight = this.heightCache / (double)lines.size();
        double offset = 0.0;
        int blinker = this.blinkerPos;
        for (String line : lines) {
            int lineLength = line.length();
            pos = this.getCharPos(ctx, x, y, center.copy(), line, lineHeight, left, bottom, width, height, offset);
            if (pos != -1) break;
            offset += lineHeight;
        }
        return pos;
    }

    private int getCharPos(RenderContext ctx, double x, double y, Vector3 center, String line, double lineHeight, double left, double bottom, double width, double height, double offset) {
        if (this.isTopAligned()) {
            center.setY(bottom + height);
        } else if (this.isBottomAligned()) {
            center.setY(bottom + lineHeight);
        } else {
            center.setY(bottom + height / 2.0 + lineHeight / 2.0);
        }
        double lineWidth = ctx.getScaledStringWidth(line);
        if (this.isLeftAligned()) {
            center.setX(left);
        } else if (this.isRightAligned()) {
            center.setX(left - this.widthCache);
        } else {
            center.setX(left + width / 2.0 - lineWidth / 2.0);
        }
        center.add(this.translateX, this.translateY - offset, 0.0);
        if (x >= center.dX()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (x < center.dX() + ctx.getScaledStringWidth(stringBuilder.append(line).append("|").toString()) && y <= center.dY() && y > center.dY() - lineHeight) {
                FontAPI<?> font = ctx.getFont();
                String trimmed = font.trimStringTo(line, (double)font.getStringWidth(line) * ((x - center.dX()) / lineWidth));
                return trimmed.length();
            }
        }
        return -1;
    }

    public double getHeight(@Nullable RenderContext ctx, double maxWidth) {
        if (!this.cached && Objects.nonNull(ctx)) {
            this.cache(ctx, maxWidth);
        }
        return this.heightCache;
    }

    public String getHighlighted() {
        if (!this.isHighlighting()) {
            return "";
        }
        if (this.highlightEnd < this.highlightStart) {
            int i = this.highlightEnd;
            this.highlightEnd = this.highlightStart;
            this.highlightStart = i;
        }
        int length = this.highlightEnd - this.highlightStart;
        return this.toString().substring(this.highlightStart, this.highlightStart + length);
    }

    public double getLeft(Vector3 center) {
        return center.dX() - (this.cached ? this.widthCache / 2.0 : 0.0);
    }

    public double getWidth(@Nullable RenderContext ctx, double maxWidth) {
        if (!this.cached && Objects.nonNull(ctx)) {
            this.cache(ctx, maxWidth);
        }
        return this.widthCache;
    }

    public void incrementBlinkerPos() {
        ++this.blinkerPos;
    }

    public void incrementHighlight() {
        if (this.highlightEnd <= this.highlightStart) {
            this.highlightStart = this.blinkerPos;
        }
        this.highlightEnd = this.blinkerPos + 1;
    }

    public boolean isBlank() {
        return Objects.isNull(this.text) || this.text.isAppliedBlank();
    }

    public boolean isBottomAligned() {
        return Misc.equalsAny(this.alignment, Alignment.BOTTOM_CENTER, Alignment.BOTTOM_LEFT, Alignment.BOTTOM_RIGHT);
    }

    public boolean isCenterAligned() {
        return Misc.equalsAny(this.alignment, Alignment.BOTTOM_CENTER, Alignment.CENTER, Alignment.TOP_CENTER);
    }

    public boolean isEmpty() {
        return Objects.isNull(this.text) || this.text.isOriginalEmpty();
    }

    public boolean isHighlighting() {
        return this.highlightStart < 0 || this.highlightEnd < 0 || this.highlightEnd != this.highlightStart;
    }

    public boolean isLeftAligned() {
        return Misc.equalsAny(this.alignment, Alignment.BOTTOM_LEFT, Alignment.LEFT, Alignment.TOP_LEFT);
    }

    public boolean isRightAligned() {
        return Misc.equalsAny(this.alignment, Alignment.BOTTOM_RIGHT, Alignment.RIGHT, Alignment.TOP_RIGHT);
    }

    public boolean isTopAligned() {
        return Misc.equalsAny(this.alignment, Alignment.TOP_CENTER, Alignment.TOP_LEFT, Alignment.TOP_RIGHT);
    }

    public void setMaxWidth(RenderContext ctx, double maxWidth) {
        this.cache(ctx, maxWidth);
    }

    public int textLength() {
        return this.toString().length();
    }

    public String toString() {
        return String.valueOf(this.text);
    }

    @Generated
    public TextAPI<?> getText() {
        return this.text;
    }

    @Generated
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Generated
    public double getLineSpacing() {
        return this.lineSpacing;
    }

    @Generated
    public double getScaleX() {
        return this.scaleX;
    }

    @Generated
    public double getScaleY() {
        return this.scaleY;
    }

    @Generated
    public double getTranslateX() {
        return this.translateX;
    }

    @Generated
    public double getTranslateY() {
        return this.translateY;
    }

    @Generated
    public RenderShape getBlinkerShape() {
        return this.blinkerShape;
    }

    @Generated
    public ColorCache getColor() {
        return this.color;
    }

    @Generated
    public void setColor(ColorCache color) {
        this.color = color;
    }

    @Generated
    public int getBlinkerPos() {
        return this.blinkerPos;
    }

    @Generated
    public void setBlinkerPos(int blinkerPos) {
        this.blinkerPos = blinkerPos;
    }

    @Generated
    public boolean isBlinkerVisible() {
        return this.blinkerVisible;
    }

    @Generated
    public void setBlinkerVisible(boolean blinkerVisible) {
        this.blinkerVisible = blinkerVisible;
    }

    @Generated
    public int getHighlightStart() {
        return this.highlightStart;
    }

    @Generated
    public void setHighlightStart(int highlightStart) {
        this.highlightStart = highlightStart;
    }

    @Generated
    public int getHighlightEnd() {
        return this.highlightEnd;
    }

    @Generated
    public void setHighlightEnd(int highlightEnd) {
        this.highlightEnd = highlightEnd;
    }

    @Generated
    public boolean isCached() {
        return this.cached;
    }

    public static enum Alignment {
        BOTTOM_CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER,
        LEFT,
        RIGHT,
        TOP_CENTER,
        TOP_LEFT,
        TOP_RIGHT;

    }

    public static class Builder {
        private final TextAPI<?> text;
        private Alignment alignment;
        private ColorCache color;
        private double lineSpacing;
        private double scaleX;
        private double scaleY;
        private double translateX;
        private double translateY;
        private int blinkerPos;
        private boolean blinkerVisible;
        private int highlightStart;
        private int highlightEnd;

        public Builder(TextAPI<?> text) {
            this.text = text;
            this.scaleX = 1.0;
            this.scaleY = 1.0;
        }

        public TextBuffer build() {
            TextBuffer built = new TextBuffer(this.text, this.alignment, this.color, this.lineSpacing, this.scaleX, this.scaleY, this.translateX, this.translateY);
            if (this.blinkerPos >= 0) {
                built.blinkerPos = MathHelper.clamp(this.blinkerPos, 0, this.text.toString().length());
                built.blinkerVisible = this.blinkerVisible;
            }
            if (this.highlightStart >= 0) {
                built.highlightStart = this.highlightStart;
            }
            if (this.highlightEnd >= 0) {
                built.highlightEnd = this.highlightEnd;
            }
            return built;
        }

        public Builder setAlignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder setColorF(Vector4 color) {
            return this.setColor(new ColorCache(color));
        }

        public Builder setColorF(float r, float g, float b, float a) {
            return this.setColor(ColorCache.of(r, g, b, a));
        }

        public Builder setColorI(Vector4 color) {
            return this.setColor(ColorCache.of(color.iX(), color.iY(), color.iZ(), color.iW()));
        }

        public Builder setColorI(int r, int g, int b, int a) {
            return this.setColor(ColorCache.of(r, g, b, a));
        }

        public Builder setColorF(ColorCache color, float alpha) {
            return this.setColor(color.withAlpha(alpha));
        }

        public Builder setColorI(ColorCache color, int alpha) {
            return this.setColor(color.withAlpha(alpha));
        }

        public Builder setColor(ColorCache color) {
            this.color = color;
            return this;
        }

        public Builder setLineSpacing(double lineSpacing) {
            this.lineSpacing = lineSpacing;
            return this;
        }

        public Builder setScale(Vector2 scale) {
            this.scaleX = scale.dX();
            this.scaleY = scale.dY();
            return this;
        }

        public Builder setScale(double x, double y) {
            this.scaleX = x;
            this.scaleY = y;
            return this;
        }

        public Builder setScaleX(double scale) {
            this.scaleX = scale;
            return this;
        }

        public Builder setScaleY(double scale) {
            this.scaleY = scale;
            return this;
        }

        public Builder setTranslation(Vector2 translation) {
            this.translateX = translation.dX();
            this.translateY = translation.dY();
            return this;
        }

        public Builder setTranslation(double x, double y) {
            this.translateX = x;
            this.translateY = y;
            return this;
        }

        public Builder setTranslateX(double scale) {
            this.translateX = scale;
            return this;
        }

        public Builder setTranslateY(double scale) {
            this.translateY = scale;
            return this;
        }
    }
}

