/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.Collection;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.TILParameterMap;

public abstract class Renderable
implements TILParameterMap {
    private final Map<String, Parameter<?>> parameters;
    private long totalTimer;
    private long maxFadeIn;
    private long fadeInTimer;
    private long maxFadeOut;
    private long fadeOutTimer;

    public Renderable(Map<String, Parameter<?>> parameters) {
        this.parameters = parameters;
    }

    public boolean canRender() {
        return this.totalTimer > 0L;
    }

    protected double getAllignmentX() {
        String alignment = this.getParameterAsString("horizontal_alignment", "center");
        return "center".equals(alignment) ? 0.0 : ("right".equals(alignment) ? 1.0 : -1.0);
    }

    protected double getAllignmentY() {
        String alignment = this.getParameterAsString("vertical_alignment", "center");
        return "center".equals(alignment) ? 0.0 : ("top".equals(alignment) ? 1.0 : -1.0);
    }

    public float getOpacity() {
        float def = this.getParameterAsFloat("opacity", 1.0f);
        if (this.fadeInTimer > 0L) {
            return def * (1.0f - (float)this.fadeInTimer / (float)this.maxFadeIn);
        }
        if (this.fadeOutTimer < this.maxFadeOut) {
            return def * ((float)this.fadeOutTimer / (float)this.maxFadeOut);
        }
        return def;
    }

    @Override
    public Parameter<?> getParameter(String name) {
        return this.parameters.get(name);
    }

    public void initializeTimers() {
        this.totalTimer = this.getParameterAsLong("time", 100L);
        this.maxFadeIn = this.getParameterAsLong("fade_in", 20L);
        this.fadeInTimer = this.getParameterAsLong("fade_in", 20L);
        this.maxFadeOut = this.getParameterAsLong("fade_out", 20L);
        this.fadeOutTimer = this.getParameterAsLong("fade_out", 20L);
    }

    @Override
    public Collection<String> keys() {
        return this.parameters.keySet();
    }

    @Override
    public Collection<Parameter<?>> parameters() {
        return this.parameters.values();
    }

    public abstract void pos(RenderContext var1);

    public void scale(RenderContext ctx) {
        double smallerScale = ctx.getScale().getSmallerDimensionScale();
        float x = (float)(this.getParameterAsDouble("scale_x", 1.0) * 0.25 * (ctx.isWide() ? smallerScale : 1.0));
        float y = (float)(this.getParameterAsDouble("scale_y", 1.0) * 0.25 * (ctx.isWide() ? 1.0 : smallerScale));
        ctx.getRenderer().scale(x, y, 1.0f);
        this.translateScaled(ctx, x, y);
    }

    abstract void render(RenderContext var1);

    public void stop() {
        this.totalTimer = 0L;
        this.fadeInTimer = 0L;
        this.maxFadeIn = 0L;
        this.fadeOutTimer = 0L;
        this.maxFadeOut = 0L;
    }

    public boolean tick() {
        if (this.totalTimer <= 0L) {
            if (this.getParameterAsBoolean("loop", false)) {
                this.initializeTimers();
                return true;
            }
            this.stop();
            return false;
        }
        if (this.fadeInTimer > 0L) {
            --this.fadeInTimer;
        }
        if (this.totalTimer <= this.fadeOutTimer) {
            --this.fadeOutTimer;
        }
        --this.totalTimer;
        return true;
    }

    protected void translateScaled(RenderContext ctx, float scaleX, float scaleY) {
        float width = (float)ctx.getScale().getScreenWidth();
        float height = (float)ctx.getScale().getScreenHeight();
        float translateX = width / (scaleX * 2.0f) - width / 2.0f;
        float translateY = height / (scaleY * 4.0f) - height / 2.0f;
        ctx.getRenderer().translate(translateX, translateY, 0.0f);
    }
}

