/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderShape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape2D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape3D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class RenderShapeOutline
extends RenderShape {
    private float lineWidth;

    public static RenderShapeOutline of(RenderShape shape) {
        return new RenderShapeOutline((Shape)shape.getWrapped(), shape.getColor(), 1.0f);
    }

    public static RenderShapeOutline of(RenderShape shape, float width) {
        return new RenderShapeOutline((Shape)shape.getWrapped(), shape.getColor(), width);
    }

    public RenderShapeOutline(Shape wrapped, ColorCache color, float lineWidth) {
        super(wrapped, color);
        this.lineWidth = lineWidth;
    }

    @Override
    public RenderShapeOutline copy() {
        return new RenderShapeOutline(((Shape)this.wrapped).copy(), this.color, this.lineWidth);
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center) {
        if (this.wrapped instanceof Shape2D) {
            ctx.drawOutline(center, (Shape2D)this.wrapped, this.lineWidth, this.color);
        } else if (this.wrapped instanceof Shape3D) {
            ctx.drawOutline(center, (Shape3D)this.wrapped, this.lineWidth, this.color);
        }
    }

    @Generated
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Generated
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }
}

