/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.Renderable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderableAnimated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderablePNG;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;

public class RenderHelper {
    private static final List<Renderable> RENDERABLES = Collections.synchronizedList(new ArrayList());
    private static Random RANDOM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRenderable(Renderable renderable) {
        List<Renderable> list = RENDERABLES;
        synchronized (list) {
            RENDERABLES.add(renderable);
            renderable.initializeTimers();
        }
    }

    public static RenderContext getContext() {
        MinecraftAPI<?> mc = ClientHelper.getMinecraft();
        return Objects.nonNull(mc) ? new RenderContext(mc) : null;
    }

    public static double getCurrentHeightRatio() {
        RenderContext ctx = RenderHelper.getContext();
        return Objects.nonNull(ctx) ? ctx.getHeightRatio() : 1.0;
    }

    public static double getDirectMouseX() {
        RenderAPI renderer = ClientHelper.getRenderer();
        return Objects.nonNull(renderer) ? renderer.getDirectMouseX() : 0.0;
    }

    public static double getDirectMouseY() {
        RenderAPI renderer = ClientHelper.getRenderer();
        return Objects.nonNull(renderer) ? renderer.getDirectMouseY() : 0.0;
    }

    public static double getScaledFontHeight() {
        RenderContext ctx = RenderHelper.getContext();
        return Objects.nonNull(ctx) ? ctx.getScaledFontHeight() : 0.0;
    }

    public static double getScaledMouseX() {
        RenderContext ctx = RenderHelper.getContext();
        return Objects.nonNull(ctx) ? ctx.getScaledMouseX() : 0.0;
    }

    public static double getScaledMouseY() {
        RenderContext ctx = RenderHelper.getContext();
        return Objects.nonNull(ctx) ? ctx.getScaledMouseY() : 0.0;
    }

    public static double getScaledStringWidth(String str) {
        RenderContext ctx = RenderHelper.getContext();
        return Objects.nonNull(ctx) ? ctx.getScaledStringWidth(str) : 0.0;
    }

    public static RenderablePNG initPNG(ResourceLocationAPI<?> source, Map<String, Parameter<?>> parameters) {
        try {
            boolean isAnimated = parameters.containsKey("animated") && Boolean.parseBoolean(parameters.get("animated").toString());
            return isAnimated ? new RenderableAnimated(source, parameters) : new RenderablePNG(source, parameters);
        }
        catch (IOException ex) {
            TILRef.logError("Failed to initialize png at resource location {}", source, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRenderable(Renderable renderable) {
        List<Renderable> list = RENDERABLES;
        synchronized (list) {
            RENDERABLES.remove(renderable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAllBackgroundStuff(RenderContext ctx) {
        List<Renderable> list = RENDERABLES;
        synchronized (list) {
            for (Renderable type : RENDERABLES) {
                type.render(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickRenderables() {
        List<Renderable> list = RENDERABLES;
        synchronized (list) {
            RENDERABLES.removeIf(renderable -> !renderable.tick());
        }
    }
}

