/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;

public class FuzzBall {
    protected Supplier<VectorSuppliers.VectorSupplier2D> generator2D;
    protected Supplier<VectorSuppliers.VectorSupplier3D> generator3D;
    protected Supplier<Float> widthGenerator;
    protected Supplier<ColorCache> colorGenerator;

    public static FuzzBall from(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<VectorSuppliers.VectorSupplier3D> generator3D) {
        return new FuzzBall(generator2D, generator3D, null, null);
    }

    public static FuzzBall from(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<VectorSuppliers.VectorSupplier3D> generator3D, Supplier<Float> widthGenerator) {
        return new FuzzBall(generator2D, generator3D, widthGenerator, null);
    }

    public static FuzzBall from(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<VectorSuppliers.VectorSupplier3D> generator3D, Supplier<Float> widthGenerator, Supplier<ColorCache> colorGenerator) {
        return new FuzzBall(generator2D, generator3D, widthGenerator, colorGenerator);
    }

    public static FuzzBall from2D(Supplier<VectorSuppliers.VectorSupplier2D> generator2D) {
        return new FuzzBall(generator2D, null, null, null);
    }

    public static FuzzBall from2D(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<Float> widthGenerator) {
        return new FuzzBall(generator2D, null, widthGenerator, null);
    }

    public static FuzzBall from2D(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<Float> widthGenerator, Supplier<ColorCache> colorGenerator) {
        return new FuzzBall(generator2D, null, widthGenerator, colorGenerator);
    }

    public static FuzzBall from3D(Supplier<VectorSuppliers.VectorSupplier3D> generator3D) {
        return new FuzzBall(null, generator3D, null, null);
    }

    public static FuzzBall from3D(Supplier<VectorSuppliers.VectorSupplier3D> generator3D, Supplier<Float> widthGenerator) {
        return new FuzzBall(null, generator3D, widthGenerator, null);
    }

    public static FuzzBall from3D(Supplier<VectorSuppliers.VectorSupplier3D> generator3D, Supplier<Float> widthGenerator, Supplier<ColorCache> colorGenerator) {
        return new FuzzBall(null, generator3D, widthGenerator, colorGenerator);
    }

    public FuzzBall(Supplier<VectorSuppliers.VectorSupplier2D> generator2D, Supplier<VectorSuppliers.VectorSupplier3D> generator3D, Supplier<Float> widthGenerator, Supplier<ColorCache> colorGenerator) {
        this.generator2D = generator2D;
        this.generator3D = generator3D;
        this.widthGenerator = widthGenerator;
        this.colorGenerator = colorGenerator;
    }

    public FuzzBall copy() {
        return new FuzzBall(this.generator2D, this.generator3D, this.widthGenerator, this.colorGenerator);
    }

    public void draw(RenderContext ctx) {
        this.draw(ctx, VectorHelper.zero3D());
    }

    public void draw(RenderContext ctx, Vector3 center) {
        float width = Objects.nonNull(this.widthGenerator) ? this.widthGenerator.get().floatValue() : 1.0f;
        ColorCache color = Objects.nonNull(this.colorGenerator) ? this.colorGenerator.get() : ColorHelper.WHITE;
        this.draw2D(ctx, center, width, color);
        this.draw3D(ctx, center, width, color);
    }

    public void draw2D(RenderContext ctx) {
        this.draw2D(ctx, VectorHelper.zero3D());
    }

    public void draw2D(RenderContext ctx, Vector3 center) {
        float width = Objects.nonNull(this.widthGenerator) ? this.widthGenerator.get().floatValue() : 1.0f;
        ColorCache color = Objects.nonNull(this.colorGenerator) ? this.colorGenerator.get() : ColorHelper.WHITE;
        this.draw2D(ctx, center, width, color);
    }

    public void draw2D(RenderContext ctx, Vector3 center, float width, ColorCache color) {
        if (Objects.isNull(this.generator2D)) {
            return;
        }
        ctx.drawOutline(center, this.generator2D.get(), width, color);
    }

    public void draw3D(RenderContext ctx) {
        this.draw3D(ctx, VectorHelper.zero3D());
    }

    public void draw3D(RenderContext ctx, Vector3 center) {
        float width = Objects.nonNull(this.widthGenerator) ? this.widthGenerator.get().floatValue() : 1.0f;
        ColorCache color = Objects.nonNull(this.colorGenerator) ? this.colorGenerator.get() : ColorHelper.WHITE;
        this.draw3D(ctx, center, width, color);
    }

    public void draw3D(RenderContext ctx, Vector3 center, float width, ColorCache color) {
        if (Objects.isNull(this.generator3D)) {
            return;
        }
        ctx.drawOutline(center, this.generator3D.get(), width, color);
    }

    @Generated
    public Supplier<VectorSuppliers.VectorSupplier2D> getGenerator2D() {
        return this.generator2D;
    }

    @Generated
    public Supplier<VectorSuppliers.VectorSupplier3D> getGenerator3D() {
        return this.generator3D;
    }

    @Generated
    public Supplier<Float> getWidthGenerator() {
        return this.widthGenerator;
    }

    @Generated
    public Supplier<ColorCache> getColorGenerator() {
        return this.colorGenerator;
    }

    @Generated
    public void setGenerator2D(Supplier<VectorSuppliers.VectorSupplier2D> generator2D) {
        this.generator2D = generator2D;
    }

    @Generated
    public void setGenerator3D(Supplier<VectorSuppliers.VectorSupplier3D> generator3D) {
        this.generator3D = generator3D;
    }

    @Generated
    public void setWidthGenerator(Supplier<Float> widthGenerator) {
        this.widthGenerator = widthGenerator;
    }

    @Generated
    public void setColorGenerator(Supplier<ColorCache> colorGenerator) {
        this.colorGenerator = colorGenerator;
    }
}

