/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Objects;
import java.util.function.BiConsumer;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ScrollableWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class WidgetList
extends ScrollableWidgetGroup {
    protected final ShapeWidget scrollBar;
    protected Widget elementTemplate;
    protected double spacing;

    public static WidgetList from(Widget template) {
        return new WidgetList(template, 0.0, 0.0, 2.0, 2.0);
    }

    public static WidgetList from(Widget template, double spacing) {
        WidgetList list = new WidgetList(template, 0.0, 0.0, 2.0, 2.0);
        list.spacing = spacing;
        return list;
    }

    public static WidgetList from(Widget template, double width, double height) {
        return new WidgetList(template, 0.0, 0.0, width, height);
    }

    public static WidgetList from(Widget template, double width, double height, double spacing) {
        WidgetList list = new WidgetList(template, 0.0, 0.0, width, height);
        list.spacing = spacing;
        return list;
    }

    public static WidgetList from(Widget template, double x, double y, double width, double height) {
        return new WidgetList(template, x, y, width, height);
    }

    public static WidgetList from(Widget template, double x, double y, double width, double height, double spacing) {
        WidgetList list = new WidgetList(template, x, y, width, height);
        list.spacing = spacing;
        return list;
    }

    public WidgetList(Widget elementTemplate, double x, double y, double width, double height) {
        double barWidth = 0.01 * (Math.min(2.0, width) / 2.0);
        this.scrollBar = ShapeWidget.from((Shape)ShapeHelper.plane(Facing.Axis.Y, new Vector2(-barWidth, -height / 2.0), new Vector2(barWidth, height / 2.0)), ColorHelper.GRAY);
        this.elementTemplate = elementTemplate;
        this.height = height;
        this.width = width;
        this.setX(x);
        this.setY(y);
        this.scrollBar.setParent(this);
        this.scrollBar.setX(this.width / 2.0 - this.scrollBar.getWidth() / 2.0);
        this.scrollBar.setY(this.y);
    }

    public void addWidgetFromTemplate(BiConsumer<Widget, Integer> settings) {
        Widget widget = this.elementTemplate.copy();
        settings.accept(widget, this.widgets.size());
        this.addWidget(widget);
    }

    protected void calculateScrollBar() {
        double height = this.getHeight();
        this.scrollBar.setHeight(height * Math.min(1.0, height / this.getElementsHeight()));
        this.scrollBar.setY(this.getRelativeTop() - this.scrollBar.getHeight() / 2.0);
    }

    @Override
    public WidgetList copy() {
        WidgetList copy = new WidgetList(this.elementTemplate, this.x, this.y, this.width, this.height);
        copy.copyScrollable(this);
        return copy;
    }

    @Override
    public boolean doesNotRequireHoverToScroll() {
        return false;
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        super.draw(ctx, center, mouseX, mouseY);
        if (Objects.nonNull(this.scrollBar) && this.scrollBar.canDraw() && this.getElementsHeight() > this.getHeight()) {
            this.scrollBar.draw(ctx, center, mouseX, mouseY);
        }
    }

    @Override
    protected double getElementsHeight() {
        double height = this.spacing;
        for (Widget widget : this.widgets) {
            if (!widget.canDraw()) continue;
            height += widget.getHeight() + this.spacing;
        }
        return height;
    }

    @Override
    protected void recalculatePositions() {
        double offset = this.spacing;
        double top = this.getRelativeTop();
        for (Widget widget : this.widgets) {
            double height = widget.getHeight();
            widget.setY(top - offset - height / 2.0);
            offset += height + this.spacing;
        }
        this.calculateScrollBar();
    }

    @Override
    public boolean scrollDown(double scroll) {
        if (super.scrollDown(scroll)) {
            this.setScrollBarPos();
            return true;
        }
        return false;
    }

    @Override
    public boolean scrollUp(double scroll) {
        if (super.scrollUp(scroll)) {
            this.setScrollBarPos();
            return true;
        }
        return false;
    }

    protected void setScrollBarPos() {
        double barHeight = this.scrollBar.getHeight();
        double height = this.getHeight();
        double top = this.getRelativeTop() - barHeight / 2.0;
        double bottom = top - height + barHeight;
        double totalScrollOffset = this.getElementsHeight() - height;
        double offset = (totalScrollOffset - this.scrollOffset) / totalScrollOffset * (top - bottom);
        this.scrollBar.setY(bottom + offset);
    }

    @Generated
    public ShapeWidget getScrollBar() {
        return this.scrollBar;
    }

    @Generated
    public Widget getElementTemplate() {
        return this.elementTemplate;
    }

    @Generated
    public double getSpacing() {
        return this.spacing;
    }

    @Generated
    public void setElementTemplate(Widget elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    @Generated
    public void setSpacing(double spacing) {
        this.spacing = spacing;
    }
}

