/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Clickable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Hoverable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Scrollable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Selectable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Tickable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Typeable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyStateCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import org.jetbrains.annotations.Nullable;

public abstract class WidgetGroup
extends Widget
implements Clickable,
Hoverable,
Scrollable,
Tickable,
Typeable {
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;
    protected Collection<Widget> widgets = new ArrayList<Widget>();

    protected WidgetGroup() {
        this(null);
    }

    protected WidgetGroup(@Nullable Widget parent) {
        super(parent);
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
        widget.setParent(this);
    }

    public void addWidgets(Widget ... widgets) {
        for (Widget widget : widgets) {
            this.addWidget(widget);
        }
    }

    public void addWidgets(Collection<Widget> widgets) {
        for (Widget widget : widgets) {
            this.addWidget(widget);
        }
    }

    protected void applyScale(RenderContext ctx) {
        ctx.getScale().modScales(this.scaleX, this.scaleY, 1.0);
    }

    @Override
    public boolean canBackspace() {
        return this.canDraw() && this.checkEachTypeable(Typeable::canBackspace);
    }

    @Override
    public boolean canType(char c) {
        return this.canDraw() && this.checkEachTypeable(typeable -> typeable.canType(c));
    }

    protected boolean checkEachClickable(Function<Clickable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Clickable && (Boolean)func.apply((Clickable)((Object)widget)) != false);
    }

    protected boolean checkEachHoverable(Function<Hoverable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Hoverable && (Boolean)func.apply((Hoverable)((Object)widget)) != false);
    }

    protected boolean checkEachScrollable(Function<Scrollable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Scrollable && (Boolean)func.apply((Scrollable)((Object)widget)) != false);
    }

    protected boolean checkEachSelectable(Function<Selectable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Selectable && (Boolean)func.apply((Selectable)((Object)widget)) != false);
    }

    protected boolean checkEachTickable(Function<Tickable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Tickable && (Boolean)func.apply((Tickable)((Object)widget)) != false);
    }

    protected boolean checkEachTypeable(Function<Typeable, Boolean> func) {
        return this.canDraw() && this.checkEachWidget(widget -> widget instanceof Typeable && (Boolean)func.apply((Typeable)((Object)widget)) != false);
    }

    protected boolean checkEachWidget(Function<Widget, Boolean> func) {
        for (Widget widget : this.widgets) {
            if (!widget.canDraw() || !func.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract WidgetGroup copy();

    protected void copyGroup(WidgetGroup other) {
        this.copyBasic(other);
        this.scaleX = other.scaleX;
        this.scaleY = other.scaleY;
        for (Widget otherChild : other.widgets) {
            if (this.widgets.contains(otherChild)) continue;
            this.addWidget(otherChild.copy());
        }
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw()) continue;
                this.drawWidget(ctx, widget, center, mouseX, mouseY);
            }
        }
    }

    protected boolean drawHoverable(RenderContext ctx, Hoverable hoverable, Vector3 center, double mouseX, double mouseY) {
        if (hoverable.isHovering(mouseX, mouseY) && hoverable.shouldDrawHovered()) {
            hoverable.drawHovered(ctx, center, mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean drawSelectable(RenderContext ctx, Selectable selectable, Vector3 center, double mouseX, double mouseY) {
        if (selectable.isSelected()) {
            selectable.drawSelected(ctx, center, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void drawHovered(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        this.draw(ctx, center, mouseX, mouseY);
    }

    public void drawWidget(RenderContext ctx, Widget widget, Vector3 center, double mouseX, double mouseY) {
        boolean drawn;
        boolean bl = drawn = widget instanceof Hoverable && this.drawHoverable(ctx, (Hoverable)((Object)widget), center, mouseX, mouseY);
        if (widget instanceof Selectable && this.drawSelectable(ctx, (Selectable)((Object)widget), center, mouseX, mouseY)) {
            drawn = true;
        }
        if (!drawn) {
            widget.draw(ctx, center, mouseX, mouseY);
        }
    }

    protected void eachClickable(Consumer<Clickable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Clickable) {
                func.accept((Clickable)((Object)widget));
            }
        });
    }

    protected void eachHoverable(Consumer<Hoverable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Hoverable) {
                func.accept((Hoverable)((Object)widget));
            }
        });
    }

    protected void eachScrollable(Consumer<Scrollable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Scrollable) {
                func.accept((Scrollable)((Object)widget));
            }
        });
    }

    protected void eachSelectable(Consumer<Selectable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Selectable) {
                func.accept((Selectable)((Object)widget));
            }
        });
    }

    protected void eachTickable(Consumer<Tickable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Tickable) {
                func.accept((Tickable)((Object)widget));
            }
        });
    }

    protected void eachTypeable(Consumer<Typeable> func) {
        this.eachWidget(widget -> {
            if (widget instanceof Typeable) {
                func.accept((Typeable)((Object)widget));
            }
        });
    }

    protected void eachWidget(Consumer<Widget> func) {
        for (Widget widget : this.widgets) {
            if (!widget.canDraw()) continue;
            func.accept(widget);
        }
    }

    protected double getElementsBottom(double z) {
        return Math.max(this.getBottom(), this.getCenter(z).dY() - this.getElementsHeight() / 2.0);
    }

    protected double getElementsHeight() {
        double top = 0.0;
        double bottom = 0.0;
        boolean first = true;
        for (Widget widget : this.widgets) {
            if (!widget.canDraw()) continue;
            double wTop = widget.getTop();
            double wBottom = widget.getBottom();
            if (first) {
                top = wTop;
                bottom = wBottom;
                first = false;
                continue;
            }
            if (wBottom < bottom) {
                bottom = wBottom;
            }
            if (!(wTop > top)) continue;
            top = wTop;
        }
        return Math.abs(top - bottom);
    }

    protected double getElementsLeft(double z) {
        return Math.max(this.getLeft(), this.getCenter(z).dX() - this.getElementsWidth() / 2.0);
    }

    protected double getElementsWidth() {
        double left = 0.0;
        double right = 0.0;
        boolean first = true;
        for (Widget widget : this.widgets) {
            if (!widget.canDraw()) continue;
            double wLeft = widget.getLeft();
            double wRight = widget.getRight();
            if (first) {
                right = wRight;
                left = wLeft;
                first = false;
                continue;
            }
            if (wLeft < left) {
                left = wLeft;
            }
            if (!(wRight > right)) continue;
            right = wRight;
        }
        return Math.abs(right - left);
    }

    protected double getElementsTop(double z) {
        return Math.min(this.getTop(), this.getCenter(z).dY() + this.getElementsHeight() / 2.0);
    }

    protected double getElementsRight(double z) {
        return Math.min(this.getRight(), this.getCenter(z).dX() + this.getElementsWidth() / 2.0);
    }

    @Nullable
    public Widget getHoveredElement(double mouseX, double mouseY) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw() || !(widget instanceof Hoverable) || !((Hoverable)((Object)widget)).isHovering(mouseX, mouseY)) continue;
                return widget;
            }
        }
        return null;
    }

    @Override
    public Collection<TextAPI<?>> getHoverLines(double mouseX, double mouseY) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw() || !(widget instanceof Hoverable) || !((Hoverable)((Object)widget)).isHovering(mouseX, mouseY)) continue;
                return ((Hoverable)((Object)widget)).getHoverLines(mouseX, mouseY);
            }
        }
        return Collections.emptyList();
    }

    public double getRelativeTop() {
        return this.getHeight() / 2.0;
    }

    @Nullable
    public Widget getSelectedElement(double mouseX, double mouseY) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw() || !(widget instanceof Selectable) || !((Selectable)((Object)widget)).isSelected()) continue;
                return widget;
            }
        }
        return null;
    }

    public boolean hasNonBlankText() {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw()) continue;
                if (widget instanceof TextWidget && ((TextWidget)widget).isNotBlank()) {
                    return true;
                }
                if (!(widget instanceof WidgetGroup) || !((WidgetGroup)widget).hasNonBlankText()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNonEmptyText() {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw()) continue;
                if (widget instanceof TextWidget && ((TextWidget)widget).isNotEmpty()) {
                    return true;
                }
                if (!(widget instanceof WidgetGroup) || !((WidgetGroup)widget).hasNonEmptyText()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActivelyTicking() {
        return this.checkEachTickable(Tickable::isActivelyTicking);
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY) {
        return this.checkEachHoverable(hoverable -> hoverable.isHovering(mouseX, mouseY));
    }

    @Override
    public boolean onBackspace() {
        return this.checkEachTypeable(Typeable::onBackspace);
    }

    @Override
    public boolean onCharTyped(char c) {
        return this.checkEachTypeable(typeable -> typeable.onCharTyped(c));
    }

    @Override
    @Nullable
    public String onCopy() {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                String copied;
                if (!widget.canDraw() || !(widget instanceof Typeable) || !Objects.nonNull(copied = ((Typeable)((Object)widget)).onCopy())) continue;
                return copied;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String onCut() {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                String copied;
                if (!widget.canDraw() || !(widget instanceof Typeable) || !Objects.nonNull(copied = ((Typeable)((Object)widget)).onCut())) continue;
                return copied;
            }
        }
        return null;
    }

    @Override
    public boolean onKeyPressed(KeyStateCache cache, int keycode) {
        return this.checkEachTypeable(typeable -> typeable.onKeyPressed(cache, keycode));
    }

    @Override
    public boolean onLeftClick(double x, double y) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw() || !(widget instanceof Clickable) || !((Clickable)((Object)widget)).onLeftClick(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPaste(@Nullable String text) {
        return this.checkEachTypeable(typeable -> typeable.onPaste(text));
    }

    @Override
    public boolean onRightClick(double x, double y) {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                if (!widget.canDraw() || !(widget instanceof Clickable) || !((Clickable)((Object)widget)).onRightClick(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onSelectAll() {
        return this.checkEachTypeable(Typeable::onSelectAll);
    }

    @Override
    public void onTick() {
        if (this.canDraw()) {
            for (Widget widget : this.widgets) {
                Tickable tickable;
                if (!widget.canDraw() || !(widget instanceof Tickable) || !(tickable = (Tickable)((Object)widget)).isActivelyTicking()) continue;
                tickable.onTick();
            }
        }
    }

    @Override
    public void playLeftClickSound() {
    }

    @Override
    public void playRightClickSound() {
    }

    @Override
    public void onResolutionUpdated(MinecraftWindow window) {
        this.eachWidget(widget -> widget.onResolutionUpdated(window));
    }

    @Override
    public boolean scrollDown(double scroll) {
        return this.checkEachScrollable(scrollable -> scrollable.scrollDown(scroll));
    }

    @Override
    public boolean scrollUp(double scroll) {
        return this.checkEachScrollable(scrollable -> scrollable.scrollUp(scroll));
    }

    public void setWidgets(Widget ... widgets) {
        this.setWidgets(new ArrayList<Widget>(Arrays.asList(widgets)));
    }

    public void setWidgets(Collection<Widget> widgets) {
        this.widgets = widgets;
        for (Widget widget : this.widgets) {
            widget.setParent(this);
        }
    }

    @Override
    public boolean shouldDrawHovered() {
        return this.checkEachHoverable(Hoverable::shouldDrawHovered);
    }

    protected void unapplyScale(RenderContext ctx) {
        ctx.getScale().modScales(1.0 / this.scaleX, 1.0 / this.scaleY, 1.0);
    }

    @Generated
    public double getScaleX() {
        return this.scaleX;
    }

    @Generated
    public double getScaleY() {
        return this.scaleY;
    }

    @Generated
    public Collection<Widget> getWidgets() {
        return this.widgets;
    }

    @Generated
    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
    }

    @Generated
    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
    }
}

