/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.Wrapped;

public class TextWidget
extends Widget
implements Wrapped<TextBuffer> {
    protected TextBuffer text;

    public static TextWidget from(TextAPI<?> text) {
        return new TextWidget(TextBuffer.of(text), 0.0, 0.0);
    }

    public static TextWidget from(TextAPI<?> text, double x, double y) {
        return new TextWidget(TextBuffer.of(text), x, y);
    }

    public static TextWidget from(TextBuffer buffer) {
        return new TextWidget(buffer, 0.0, 0.0);
    }

    public static TextWidget from(TextBuffer buffer, double x, double y) {
        return new TextWidget(buffer, x, y);
    }

    public static TextWidget literal(String literal) {
        return new TextWidget(TextBuffer.literal(literal), 0.0, 0.0);
    }

    public static TextWidget literal(String literal, double x, double y) {
        return new TextWidget(TextBuffer.literal(literal), x, y);
    }

    public static TextWidget translated(String key) {
        return new TextWidget(TextBuffer.translated(key, new Object[0]), 0.0, 0.0);
    }

    public static TextWidget translated(String key, Object ... args) {
        return new TextWidget(TextBuffer.translated(key, args), 0.0, 0.0);
    }

    public static TextWidget translated(String key, double x, double y) {
        return new TextWidget(TextBuffer.translated(key, new Object[0]), x, y);
    }

    public static TextWidget translated(String key, Object[] args, double x, double y) {
        return new TextWidget(TextBuffer.translated(key, args), x, y);
    }

    public TextWidget(TextBuffer text, double x, double y) {
        this.text = text;
        this.setX(x);
        this.setY(y);
    }

    public ColorCache getColor() {
        return this.text.getColor();
    }

    @Override
    public TextWidget copy() {
        TextWidget copy = new TextWidget(this.text.copy(), this.x, this.y);
        copy.copyBasic(this);
        return copy;
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (Objects.nonNull(this.text)) {
            center = this.getCenter(center.dZ()).add(center.dX(), center.dY(), 0.0);
            double width = this.getWidth();
            double parentWidth = Objects.nonNull(this.parent) ? this.parent.getWidth() : 0.0;
            double height = this.getHeight();
            this.text.draw(ctx, this.getCenter(center.dZ()), this.getMinX(center.dX(), width, parentWidth), this.getMinY(center.dY(), height), this.getMaxX(center.dX(), width, parentWidth), this.getMaxY(center.dY(), height));
        }
    }

    @Override
    public double getHeight() {
        double maxWidth = Objects.nonNull(this.parent) ? this.parent.getWidth() : 2.0;
        return this.text.getHeight(RenderHelper.getContext(), maxWidth);
    }

    public double getMaxX(double centerX, double width, double parentWidth) {
        return centerX + (parentWidth > 0.0 ? parentWidth : width) / 2.0;
    }

    public double getMaxY(double centerY, double height) {
        return centerY + height / 2.0;
    }

    public double getMinX(double centerX, double width, double parentWidth) {
        return centerX - (parentWidth > 0.0 ? parentWidth : width) / 2.0;
    }

    public double getMinY(double centerY, double height) {
        return centerY - height / 2.0;
    }

    @Override
    public double getWidth() {
        double maxWidth = Objects.nonNull(this.parent) ? this.parent.getWidth() : 2.0;
        return this.text.getWidth(RenderHelper.getContext(), maxWidth);
    }

    @Override
    public TextBuffer getWrapped() {
        return this.text;
    }

    public boolean isBlank() {
        return Objects.isNull(this.text) || this.text.isBlank();
    }

    public boolean isNotBlank() {
        return Objects.nonNull(this.text) && !this.text.isBlank();
    }

    public boolean isNotEmpty() {
        return Objects.nonNull(this.text) && !this.text.isEmpty();
    }

    public boolean isEmpty() {
        return Objects.isNull(this.text) || this.text.isEmpty();
    }

    @Override
    public void onResolutionUpdated(MinecraftWindow window) {
    }

    public TextWidget setColor(ColorCache color) {
        this.text.setColor(color);
        return this;
    }

    public TextWidget setText(String text) {
        return this.setText(this.text.copyTo(TextHelper.getLiteral(text)));
    }

    public TextWidget setText(TextAPI<?> text) {
        return this.setText(this.text.copyTo(text));
    }

    public TextWidget setText(TextBuffer text) {
        this.text = text;
        return this;
    }

    @Override
    public void setWidth(double width) {
        this.text.setMaxWidth(RenderContext.get(ClientHelper.getMinecraft()), width);
    }

    public int textLength() {
        return this.toString().length();
    }

    public String toString() {
        return String.valueOf(this.text);
    }
}

