/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextureWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorStreams;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import org.jetbrains.annotations.Nullable;

public class ScreenHelper {
    @Nullable
    public static ScreenHelperAPI getAPI() {
        return TILRef.getClientSubAPI(ClientAPI::getScreenHelper);
    }

    public static TextureWrapper getVanillaButtonTexture(boolean hover, boolean disabled) {
        ScreenHelperAPI api = ScreenHelper.getAPI();
        return Objects.nonNull(api) ? api.getVanillaButtonTexture(hover, disabled) : new TextureWrapper().setMask(ColorHelper.LIGHT_PURPLE);
    }

    public static void open(Function<Integer, ScreenAPI> withGuiScale) {
        ScreenHelperAPI api = ScreenHelper.getAPI();
        if (Objects.isNull(api)) {
            TILRef.logError("Failed to open screen with GUI scale function since ScreenHelperAPI is null", new Object[0]);
            return;
        }
        ClientHelper.scheduleRunnable(() -> {
            ScreenAPI screen = (ScreenAPI)withGuiScale.apply(ClientHelper.getGuiScale());
            api.open(screen);
        });
    }

    public static void open(ScreenAPI screen) {
        ScreenHelper.open((Integer i) -> screen);
    }

    public static void playVanillaClickSound() {
        ScreenHelperAPI api = ScreenHelper.getAPI();
        if (Objects.nonNull(api)) {
            api.playVanillaClickSound();
        }
    }

    public static VectorSuppliers.VectorSupplier2D randomPointSupplier2D(Supplier<Vector2> supplier, int minCount, int maxCount) {
        Vector2[] vectors = new Vector2[RandomHelper.randomInt(minCount, maxCount)];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = supplier.get();
        }
        return VectorStreams.get2D(vectors);
    }

    public static VectorSuppliers.VectorSupplier3D randomPointSupplier3D(Supplier<Vector3> supplier, int minCount, int maxCount) {
        Vector3[] vectors = new Vector3[RandomHelper.randomInt(minCount, maxCount)];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = supplier.get();
        }
        return VectorStreams.get3D(vectors);
    }

    public static VectorSuppliers.VectorSupplier4D randomPointSupplier4D(Supplier<Vector4> supplier, int minCount, int maxCount) {
        Vector4[] vectors = new Vector4[RandomHelper.randomInt(minCount, maxCount)];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = supplier.get();
        }
        return VectorStreams.get4D(vectors);
    }
}

