/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.AnchoredGeometry;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.ITickableGeometry;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;

public class GeometryHelper {
    public static final List<AnchoredGeometry> ANCHORED_RENDERS = Collections.synchronizedList(new ArrayList());
    public static final List<ITickableGeometry<?>> TICKABLE_RENDERS = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(RenderContext ctx, float partialTicks) {
        List<AnchoredGeometry> list = ANCHORED_RENDERS;
        synchronized (list) {
            Iterator<AnchoredGeometry> renderItr = ANCHORED_RENDERS.iterator();
            while (renderItr.hasNext()) {
                AnchoredGeometry staticRender = renderItr.next();
                if (staticRender.isEmpty()) {
                    renderItr.remove();
                    if (!(staticRender instanceof ITickableGeometry)) continue;
                    TICKABLE_RENDERS.remove(staticRender);
                    continue;
                }
                staticRender.render(ctx, partialTicks);
            }
        }
    }

    public static void tick() {
        Iterator<ITickableGeometry<?>> tickItr = TICKABLE_RENDERS.iterator();
        while (tickItr.hasNext()) {
            ITickableGeometry<?> tickable = tickItr.next();
            tickable.onTick();
            if (tickable.isInitialized()) continue;
            tickItr.remove();
            if (!(tickable instanceof AnchoredGeometry)) continue;
            TICKABLE_RENDERS.remove(tickable);
        }
    }
}

