/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.forge;

import gs.mclo.forge.MclogsCommandHandler;
import gs.mclo.mclogs.APIResponse;
import gs.mclo.mclogs.MclogsAPI;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mclogs", name="Mclogs", version="1.0.6")
public class MclogsForgeLoader {
    public static final String modid = "mclogs";
    public static final String name = "Mclogs";
    public static final String version = "1.0.6";
    public static final Logger logger = LogManager.getLogger();
    public static String logsdir;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        MclogsAPI.mcversion = event.getServer().func_71249_w();
        MclogsAPI.userAgent = "Mclogs-forge";
        MclogsAPI.version = version;
        try {
            logsdir = event.getServer().func_71209_f("logs").getCanonicalPath() + "/";
        }
        catch (IOException e) {
            logger.error("couldn't read logs directory");
            logger.error((Object)e);
            return;
        }
        event.registerServerCommand((ICommand)new MclogsCommandHandler());
    }

    public static int share(ICommandSender source, String filename) {
        logger.info("Sharing " + filename);
        try {
            APIResponse response = MclogsAPI.share(logsdir + filename);
            if (response.success) {
                Style s = new Style().func_150238_a(TextFormatting.GREEN);
                TextComponentString feedback = new TextComponentString("Your log has been uploaded: ");
                feedback.func_150255_a(s);
                TextComponentString link = new TextComponentString(response.url);
                link.func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, response.url)));
                source.func_145747_a(feedback.func_150257_a((ITextComponent)link));
                return 1;
            }
            logger.error("An error occurred when uploading your log", (Object)response.error);
            logger.error(response.error);
            TextComponentString error = new TextComponentString("An error occurred. Check your log for more details");
            error.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            source.func_145747_a((ITextComponent)error);
            return -1;
        }
        catch (FileNotFoundException e) {
            TextComponentString error = new TextComponentString("The log file " + filename + " doesn't exist. Use '/mclogs list' to list all logs.");
            error.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            source.func_145747_a((ITextComponent)error);
            return -1;
        }
        catch (IOException e) {
            logger.error("An error occurred when reading your log.");
            logger.error((Object)e);
            TextComponentString error = new TextComponentString("An error occurred. Check your log for more details.");
            error.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            source.func_145747_a((ITextComponent)error);
            return -1;
        }
    }
}

