/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.witherconfig.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.redstudio.witherconfig.ProjectConstants;
import dev.redstudio.witherconfig.config.WitherConfigConfig;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EntityWitherSkull.class})
public final class EntityWitherSkullMixin {
    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=0))
    private float changeDamage(float original) {
        return WitherConfigConfig.common.skulls.damage;
    }

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z", ordinal=1))
    private float changeMagicDamage(float original) {
        return WitherConfigConfig.common.skulls.magicDamage;
    }

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;heal(F)V"))
    private float changeHeal(float original) {
        return WitherConfigConfig.common.skulls.healOnKill;
    }

    @ModifyArg(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    private float changeExplosionStrength(float original) {
        return WitherConfigConfig.common.skulls.explosionStrength;
    }

    @Redirect(method={"onImpact"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;addPotionEffect(Lnet/minecraft/potion/PotionEffect;)V"))
    private void redirectAddPotionEffect(EntityLivingBase entityLiving, PotionEffect potionEffect, @Local int durationMultiplier) {
        for (String line : WitherConfigConfig.common.skulls.effects) {
            String[] parts = line.split(";");
            if (parts.length != 3) {
                ProjectConstants.LOGGER.error("Malformed potion effect config: {}", (Object)line);
                return;
            }
            Potion potion = Potion.func_180142_b((String)parts[0]);
            int duration = Integer.parseInt(parts[1]) * durationMultiplier;
            int level = Integer.parseInt(parts[2]);
            if (potion != null) {
                entityLiving.func_70690_d(new PotionEffect(potion, duration, level));
                continue;
            }
            ProjectConstants.LOGGER.error("Potion/effect was not found {}", (Object)parts[0]);
        }
    }
}

