/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.witherconfig.mixin;

import dev.redstudio.witherconfig.config.WitherConfigConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityWither.class})
public abstract class EntityWitherMixin
extends EntityMob {
    private EntityWitherMixin(World world) {
        super(world);
    }

    @Shadow
    public abstract int func_82203_t(int var1);

    @Shadow
    public abstract boolean func_82205_o();

    @Inject(method={"canDestroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fluidBreakingCheck(Block blockIn, CallbackInfoReturnable<Boolean> booleanCallbackInfoReturnable) {
        if (!WitherConfigConfig.common.breakLiquids && blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            booleanCallbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @ModifyArg(method={"applyEntityAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/attributes/IAttributeInstance;setBaseValue(D)V", ordinal=0))
    private double changeMaxHealth(double original) {
        return WitherConfigConfig.common.maxHealth;
    }

    @ModifyArg(method={"applyEntityAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/attributes/IAttributeInstance;setBaseValue(D)V", ordinal=1))
    private double changeMovementSpeed(double original) {
        return WitherConfigConfig.common.movementSpeed;
    }

    @ModifyArg(method={"applyEntityAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/attributes/IAttributeInstance;setBaseValue(D)V", ordinal=2))
    private double changeFollowRange(double original) {
        return WitherConfigConfig.common.followRange;
    }

    @ModifyArg(method={"applyEntityAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/attributes/IAttributeInstance;setBaseValue(D)V", ordinal=3))
    private double changeArmor(double original) {
        return WitherConfigConfig.common.armor;
    }

    @ModifyArg(method={"ignite"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/EntityWither;setInvulTime(I)V"))
    private int changeSummonSequenceLength(int original) {
        return WitherConfigConfig.common.summonSequence.length;
    }

    @ModifyArg(method={"updateAITasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    private float changeEndExplosionStrength(float original) {
        return WitherConfigConfig.common.summonSequence.endExplosionStrength;
    }

    @ModifyArg(method={"updateAITasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/EntityWither;heal(F)V", ordinal=0))
    private float changeInvulnerableHealing(float original) {
        return WitherConfigConfig.common.healing.invulnerableHealing;
    }

    @ModifyArg(method={"updateAITasks"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/EntityWither;heal(F)V", ordinal=1))
    private float changeVulnerableHealing(float original) {
        return WitherConfigConfig.common.healing.vulnerableHealing;
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/boss/EntityWither;getWatchedTargetId(I)I", ordinal=0))
    private int disableVanillaTargetFollowingLogic(EntityWither instance, int head) {
        return 0;
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    private void newTargetFollowingLogic(CallbackInfo callbackInfo) {
        double deltaZ;
        double deltaX;
        double distanceToTarget;
        if (this.field_70170_p.field_72995_K || this.func_82203_t(0) <= 0) {
            return;
        }
        Entity target = this.field_70170_p.func_73045_a(this.func_82203_t(0));
        if (target == null) {
            return;
        }
        if (target instanceof EntityPlayer && WitherConfigConfig.common.breakBlocksWhenTargetingPlayer) {
            this.wither_Config$destroyBlocks(target.field_70163_u);
        }
        double movementSpeed = WitherConfigConfig.common.movementSpeed;
        if (this.field_70163_u < target.field_70163_u || !this.func_82205_o() && this.field_70163_u < target.field_70163_u + (double)WitherConfigConfig.common.unarmoredFlyHeight) {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
            this.field_70181_x += (0.5 - this.field_70181_x) * movementSpeed;
        }
        if ((distanceToTarget = Math.sqrt((deltaX = target.field_70165_t - this.field_70165_t) * deltaX + (deltaZ = target.field_70161_v - this.field_70161_v) * deltaZ)) > (double)WitherConfigConfig.common.followDistance) {
            this.field_70159_w += (deltaX / distanceToTarget * 0.5 - this.field_70159_w) * movementSpeed;
            this.field_70179_y += (deltaZ / distanceToTarget * 0.5 - this.field_70179_y) * movementSpeed;
        }
    }

    @Unique
    private void wither_Config$destroyBlocks(double targetY) {
        if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean playSound = false;
        int desiredYOffset = targetY < this.field_70163_u ? -1 : 0;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                for (int yOffset = desiredYOffset; yOffset <= 4; ++yOffset) {
                    int currentX = x + xOffset;
                    int currentY = y + yOffset;
                    int currentZ = z + zOffset;
                    BlockPos blockPos = new BlockPos(currentX, currentY, currentZ);
                    IBlockState blockState = this.field_70170_p.func_180495_p(blockPos);
                    if (!blockState.func_177230_c().canEntityDestroy(blockState, (IBlockAccess)this.field_70170_p, blockPos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockPos, (IBlockState)blockState)) continue;
                    playSound = this.field_70170_p.func_175655_b(blockPos, true) || playSound;
                }
            }
        }
        if (playSound) {
            this.field_70170_p.func_180498_a(null, 1022, new BlockPos((Entity)this), 0);
        }
    }
}

