/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.witherconfig.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="witherconfig", name="Wither Config")
public final class WitherConfigConfig {
    public static final Common common = new Common();

    @Mod.EventBusSubscriber(modid="witherconfig")
    public static final class ConfigEventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
            if (!onConfigChangedEvent.getModID().equals("witherconfig")) {
                return;
            }
            ConfigManager.sync((String)"witherconfig", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Common {
        public final SummonSequence summonSequence = new SummonSequence();
        public final Healing healing = new Healing();
        public final Skulls skulls = new Skulls();
        public final BoatJailFix boatJailFix = new BoatJailFix();
        public boolean breakBlocksWhenTargetingPlayer = false;
        public boolean breakLiquids = true;
        public float unarmoredFlyHeight = 5.0f;
        public float followDistance = 9.0f;
        public double maxHealth = 300.0;
        public double movementSpeed = 0.6;
        public double followRange = 40.0;
        public double armor = 4.0;

        public static class BoatJailFix {
            @Config.RequiresMcRestart
            public boolean enabled = true;
            public byte tickDelay = (byte)5;
            public int range = 7;
        }

        public static class Skulls {
            public float damage = 8.0f;
            public float magicDamage = 5.0f;
            public float healOnKill = 5.0f;
            public float explosionStrength = 1.0f;
            public String[] effects = new String[]{"minecraft:wither;20;1"};
        }

        public static class Healing {
            public float invulnerableHealing = 10.0f;
            public float vulnerableHealing = 1.0f;
        }

        public static class SummonSequence {
            public int length = 220;
            public float endExplosionStrength = 7.0f;
        }
    }
}

