/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.util.TagUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.property.PropertyString;

public final class TextureBlockUtil {
    public static final String TAG_TEXTURE = "texture";
    public static final PropertyString TEXTURE_PROP = new PropertyString("TEXTURE");

    private TextureBlockUtil() {
    }

    public static void placeTextureBlock(World world, BlockPos pos, ItemStack stack) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            NBTTagCompound textureTag = tag.func_74775_l(TAG_TEXTURE);
            if (textureTag == null) {
                textureTag = new NBTTagCompound();
            }
            TextureBlockUtil.updateTextureBlock(te, textureTag);
        }
    }

    public static ItemStack getBlockItemStack(IBlockAccess world, BlockPos pos, IBlockState state) {
        NBTTagCompound texture;
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block, 1, block.func_180651_a(state));
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (texture = TextureBlockUtil.getTextureBlock(te)).func_186856_d() > 0) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74782_a(TAG_TEXTURE, (NBTBase)texture);
            stack.func_77982_d(tags);
        }
        return stack;
    }

    public static void updateTextureBlock(TileEntity te, NBTTagCompound tag) {
        if (te != null) {
            te.getTileData().func_74782_a(TAG_TEXTURE, (NBTBase)tag);
        }
    }

    public static NBTTagCompound getTextureBlock(TileEntity te) {
        if (te == null) {
            return new NBTTagCompound();
        }
        return te.getTileData().func_74775_l(TAG_TEXTURE);
    }

    public static ItemStack createTexturedStack(Block texturable, int texMeta, Block block, int blockMeta) {
        ItemStack stack = new ItemStack(texturable, 1, texMeta);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.func_77955_b(subTag);
            tag.func_74782_a(TAG_TEXTURE, (NBTBase)subTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static ItemStack getStackTexture(ItemStack table) {
        NBTTagCompound tag = TagUtil.getTagSafe(table).func_74775_l(TAG_TEXTURE);
        return new ItemStack(tag);
    }

    public static void addBlocksFromOredict(String oredict, Block block, int meta, NonNullList<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict, (boolean)false)) {
            Block textureBlock = Block.func_149634_a((Item)stack.func_77973_b());
            int textureMeta = stack.func_77960_j();
            if (textureMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.func_191196_a();
                textureBlock.func_149666_a(CreativeTabs.field_78027_g, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add((Object)TextureBlockUtil.createTexturedStack(block, meta, Block.func_149634_a((Item)subBlock.func_77973_b()), subBlock.func_77960_j()));
                    if (Config.showAllVariants) continue;
                    return;
                }
                continue;
            }
            list.add((Object)TextureBlockUtil.createTexturedStack(block, meta, textureBlock, textureMeta));
            if (Config.showAllVariants) continue;
            return;
        }
    }
}

