/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether.trees;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.natural.BlockAetherGrass;
import com.gildedgames.the_aether.blocks.natural.BlockAetherLog;
import com.gildedgames.the_aether.blocks.util.EnumLogType;
import com.gildedgames.the_aether.items.ItemsAether;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreestheaether.ModConfigs;
import maxhyper.dynamictreestheaether.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class ALTreeSkyroot
extends TreeFamily {
    public static Block leavesBlock = BlocksAether.aether_leaves;
    public static Block logBlock = BlocksAether.aether_log;
    public static Block saplingBlock = BlocksAether.skyroot_sapling;

    public ALTreeSkyroot() {
        super(new ResourceLocation("dynamictreestheaether", "skyroot"));
        this.setPrimitiveLog(logBlock.func_176223_P().func_177226_a((IProperty)BlockAetherLog.wood_type, (Comparable)EnumLogType.Skyroot), new ItemStack(logBlock, 1, 0));
        ModContent.skyrootLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        return new ItemStack(ItemsAether.skyroot_stick, qty);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesSkyroot(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesSkyroot
    extends Species {
        SpeciesSkyroot(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.skyrootLeavesProperties);
            this.setBasicGrowingParameters(this.tapering, this.signalEnergy / 2.0f, this.upProbability, this.lowestBranchHeight, this.growthRate);
            this.envFactor(BiomeDictionary.Type.COLD, 1.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.9f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.clearAcceptableSoils();
            this.addAcceptableSoils(new String[]{ModContent.AETHERLIKE});
        }

        public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
            if (AetherConfig.world_gen.christmas_time && world.field_73012_v.nextFloat() < ModConfigs.holidayTreeChance) {
                Species holiday = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestheaether", "holiday"));
                return holiday.generate(world, rootPos, biome, random, radius, safeBounds);
            }
            if (rootPos.func_177956_o() >= 100) {
                if (world.func_180495_p(rootPos).func_177230_c() == BlocksAether.aether_grass && ((Boolean)world.func_180495_p(rootPos).func_177229_b((IProperty)BlockAetherGrass.dungeon_block)).booleanValue()) {
                    Species goldenOak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestheaether", "goldenoak"));
                    return goldenOak.generate(world, rootPos, biome, random, radius, safeBounds);
                }
                return false;
            }
            return super.generate(world, rootPos, biome, random, radius, safeBounds);
        }
    }
}

