/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.natural.BlockAetherLog;
import com.gildedgames.the_aether.blocks.util.EnumLogType;
import com.gildedgames.the_aether.items.ItemsAether;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreestheaether.ModConfigs;
import maxhyper.dynamictreestheaether.ModContent;
import maxhyper.dynamictreestheaether.genfeatures.FeatureGenCrystalTopper;
import maxhyper.dynamictreestheaether.genfeatures.FeatureGenRandomLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class ALTreeCrystal
extends TreeFamily {
    public static Block leavesBlock = BlocksAether.crystal_leaves;
    public static Block logBlock = BlocksAether.aether_log;

    public ALTreeCrystal() {
        super(new ResourceLocation("dynamictreestheaether", "crystal"));
        this.hasConiferVariants = true;
        this.setPrimitiveLog(logBlock.func_176223_P().func_177226_a((IProperty)BlockAetherLog.wood_type, (Comparable)EnumLogType.Skyroot), new ItemStack(logBlock, 1, 0));
        ModContent.crystalLeavesProperties.setTree((TreeFamily)this);
        ModContent.crystalFruitLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), qty, 0);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        return new ItemStack(ItemsAether.skyroot_stick, qty);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCrystal(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesCrystal
    extends Species {
        SpeciesCrystal(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.crystalLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 8.0f, 3, 3, 0.6f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
            this.addValidLeavesBlocks(new ILeavesProperties[]{ModContent.crystalFruitLeavesProperties});
            this.envFactor(BiomeDictionary.Type.COLD, 1.4f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.2f);
            this.addDropCreator((IDropCreator)new DropCreatorSeed(){

                public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                    float rarity = this.getHarvestRarity();
                    rarity *= (float)(fortune + 1) / 128.0f;
                    if ((rarity = (float)((double)rarity * Math.min((double)(species.seasonalSeedDropFactor(world, leafPos) + 0.15f), 1.0))) > random.nextFloat()) {
                        dropList.add(this.getFruit());
                    }
                    return dropList;
                }

                private ItemStack getFruit() {
                    return new ItemStack(ItemsAether.white_apple);
                }

                public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                    int chance = 40;
                    if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                        chance = 10;
                    }
                    float seasonFactor = 1.0f;
                    if (access instanceof World) {
                        World world = (World)access;
                        if (!world.field_72995_K) {
                            seasonFactor = species.seasonalSeedDropFactor(world, breakPos);
                        }
                    }
                    if (random.nextInt((int)((float)chance / this.getLeavesRarity())) == 0 && seasonFactor > random.nextFloat()) {
                        dropList.add(this.getFruit());
                    }
                    return dropList;
                }
            });
            if (ModConfigs.fruityLeaves) {
                this.addGenFeature((IGenFeature)new FeatureGenRandomLeaves(4, 12, (Block)ModContent.crystalLeaves, 0, 1, 0.3f, ModConfigs.crystalTreesGrow || ModContent.lostAetherLoaded).setFruitingRadius(2));
            }
            ModContent.blockWhiteApple.setSpecies((Species)this);
            this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.blockWhiteApple).setFruitingRadius(ModConfigs.crystalTreesGrow || ModContent.lostAetherLoaded ? 2 : 9));
            this.generateSeed();
            this.clearAcceptableSoils();
            this.addAcceptableSoils(new String[]{ModContent.AETHERLIKE});
            this.addGenFeature((IGenFeature)new FeatureGenCrystalTopper(this.getLeavesProperties()));
        }

        public float seasonalFruitProductionFactor(World world, BlockPos pos) {
            return 1.0f;
        }
    }
}

