/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether.growth;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.cells.CellConiferBranch;
import com.ferreusveritas.dynamictrees.cells.CellConiferLeaf;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.util.ResourceLocation;

public class CustomCellKits
extends CellKits {
    private final ICellKit sugi = new ICellKit(){
        private final ICell sugiBranch = new CellConiferBranch();
        private final ICell[] coniferLeafCells = new ICell[]{CellNull.NULLCELL, new CellConiferLeaf(1), new CellConiferLeaf(2), new CellConiferLeaf(3), new CellConiferLeaf(4)};
        private final CellKits.BasicSolver coniferSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            if (radius <= 3) {
                return this.sugiBranch;
            }
            return CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.conifer;
        }

        public ICellSolver getCellSolver() {
            return this.coniferSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void preInit() {
        new CustomCellKits();
    }

    public CustomCellKits() {
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictreestheaether", "sugi"), (ICellKit)this.sugi);
    }
}

