/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenSnowArea
implements IPostGenFeature {
    public int snowRadius;
    public IBlockState present;
    public int presentOdds;
    private static boolean gap = true;

    public FeatureGenSnowArea(int snowAreaRadius, IBlockState specialBlock, int specialBlockOdds) {
        this.snowRadius = snowAreaRadius;
        this.present = specialBlock;
        this.presentOdds = specialBlockOdds;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        this.generateSnow(world, rootPos, safeBounds);
        return true;
    }

    public boolean addSnowLayer(World world, BlockPos pos, Random rand, SafeChunkBounds safeBounds) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_189649_b(pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
        if (!safeBounds.inBounds(blockpos, gap) || blockpos.func_177956_o() <= 1) {
            return false;
        }
        if (rand.nextInt(this.presentOdds) == 0) {
            safeBounds.setBlockState(world, blockpos, this.present, gap);
            return true;
        }
        if (world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150431_aC && (Integer)world.func_180495_p(blockpos.func_177977_b()).func_177229_b((IProperty)BlockSnow.field_176315_a) < 8) {
            safeBounds.setBlockState(world, blockpos.func_177977_b(), Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf((Integer)world.func_180495_p(blockpos.func_177977_b()).func_177229_b((IProperty)BlockSnow.field_176315_a) + 1)), gap);
            return true;
        }
        if (Blocks.field_150431_aC.func_176196_c(world, blockpos) && blockpos.func_177956_o() > 0) {
            safeBounds.setBlockState(world, blockpos, Blocks.field_150431_aC.func_176223_P(), gap);
            return true;
        }
        return false;
    }

    public void generateSnow(World world, BlockPos rootPos, SafeChunkBounds safeBounds) {
        Random rand = new Random();
        for (int x = rootPos.func_177958_n() - this.snowRadius; x < rootPos.func_177958_n() + this.snowRadius; ++x) {
            for (int z = rootPos.func_177952_p() - this.snowRadius; z < rootPos.func_177952_p() + this.snowRadius; ++z) {
                double distFromRoot = Math.sqrt(Math.pow(rootPos.func_177958_n() - x, 2.0) + Math.pow(rootPos.func_177952_p() - z, 2.0));
                if (!(distFromRoot <= (double)this.snowRadius) || !((double)rand.nextFloat() * (distFromRoot / (double)this.snowRadius) <= 0.5)) continue;
                this.addSnowLayer(world, new BlockPos(x, 0, z), rand, safeBounds);
            }
        }
    }
}

