/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import maxhyper.dynamictreestheaether.ModConfigs;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenRandomLeaves
implements IPostGenFeature,
IPostGrowFeature {
    public int boxSize;
    public int boxHeight;
    public Block leaf;
    public float worldGenProportion;
    protected int fruitingRadius = 8;
    protected int treeEmpty;
    protected int treeFruit;
    protected boolean enableGrowth;

    public FeatureGenRandomLeaves(int size, int height, Block leafBlock, int treeEmpty, int treeFruit, float proportionForWorldgen, boolean enableGrowth) {
        this.boxSize = size;
        this.boxHeight = height;
        this.leaf = leafBlock;
        this.treeEmpty = treeEmpty;
        this.treeFruit = treeFruit;
        this.worldGenProportion = proportionForWorldgen;
        this.enableGrowth = enableGrowth;
    }

    public FeatureGenRandomLeaves setFruitingRadius(int fruitingRadius) {
        this.fruitingRadius = fruitingRadius;
        return this;
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        if (this.enableGrowth && ModConfigs.fruityLeaves && TreeHelper.getRadius((IBlockAccess)world, (BlockPos)rootPos.func_177984_a()) >= this.fruitingRadius && natural) {
            this.changeRandLeaf(world, rootPos, 2, species);
        }
        return false;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        this.changeLeaves(world, rootPos, this.worldGenProportion, species, safeBounds);
        return true;
    }

    private boolean isLeavesValid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this.leaf && (Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) == 1;
    }

    private void attemptLeafChange(World world, BlockPos pos, boolean worldGen, Species species, SafeChunkBounds safeBounds) {
        if (worldGen) {
            if (safeBounds.inBounds(pos, true) && this.isLeavesValid(world, pos) && (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicLeaves.TREE) == this.treeEmpty) {
                world.func_175656_a(pos, this.leaf.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(this.treeFruit)));
            }
        } else if (this.isLeavesValid(world, pos)) {
            int treeValue = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicLeaves.TREE);
            if (treeValue == this.treeFruit) {
                world.func_175656_a(pos, this.leaf.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(this.treeEmpty)));
                return;
            }
            if (world.field_73012_v.nextFloat() <= species.seasonalFruitProductionFactor(world, pos)) {
                if (treeValue == this.treeEmpty) {
                    world.func_175656_a(pos, this.leaf.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(this.treeFruit)));
                } else if (treeValue == this.treeFruit) {
                    world.func_175656_a(pos, this.leaf.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(this.treeEmpty)));
                }
            }
        }
    }

    private void changeRandLeaf(World world, BlockPos rootPos, int attempts, Species species) {
        Random rand = new Random();
        do {
            int randX = rootPos.func_177958_n() + rand.nextInt(2 * this.boxSize + 1) - this.boxSize;
            int randZ = rootPos.func_177952_p() + rand.nextInt(2 * this.boxSize + 1) - this.boxSize;
            int randY = rootPos.func_177956_o() + rand.nextInt(this.boxHeight + 1);
            this.attemptLeafChange(world, new BlockPos(randX, randY, randZ), false, species, null);
        } while (attempts-- > 0);
    }

    private void changeLeaves(World world, BlockPos rootPos, float proportion, Species species, SafeChunkBounds safeBounds) {
        if (proportion <= 0.0f || proportion > 1.0f) {
            return;
        }
        Random rand = new Random();
        for (int x = rootPos.func_177958_n() - this.boxSize; x < rootPos.func_177958_n() + 2 * this.boxSize; ++x) {
            for (int z = rootPos.func_177952_p() - this.boxSize; z < rootPos.func_177952_p() + 2 * this.boxSize; ++z) {
                for (int y = rootPos.func_177956_o(); y < rootPos.func_177956_o() + this.boxHeight; ++y) {
                    if (!(rand.nextFloat() * (1.0f / proportion) <= 1.0f)) continue;
                    this.attemptLeafChange(world, new BlockPos(x, y, z), true, species, safeBounds);
                }
            }
        }
    }
}

