/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestheaether;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.natural.BlockAetherLeaves;
import com.gildedgames.the_aether.blocks.natural.BlockCrystalLeaves;
import com.gildedgames.the_aether.blocks.natural.BlockHolidayLeaves;
import com.gildedgames.the_aether.blocks.util.EnumCrystalType;
import com.gildedgames.the_aether.blocks.util.EnumHolidayType;
import com.gildedgames.the_aether.blocks.util.EnumLeafType;
import com.gildedgames.the_aether.items.ItemsAether;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import maxhyper.dynamictreestheaether.blocks.BlockDynamicLeavesAether;
import maxhyper.dynamictreestheaether.blocks.BlockDynamicLeavesCrystal;
import maxhyper.dynamictreestheaether.trees.ALTreeCrystal;
import maxhyper.dynamictreestheaether.trees.ALTreeGoldenOak;
import maxhyper.dynamictreestheaether.trees.ALTreeHoliday;
import maxhyper.dynamictreestheaether.trees.ALTreeSkyroot;
import maxhyper.dynamictreestheaether.worldgen.BiomeDataBasePopulator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictreestheaether")
@GameRegistry.ObjectHolder(value="dynamictreestheaether")
public class ModContent {
    public static BlockDynamicLeaves crystalLeaves;
    public static BlockDynamicLeaves aetherLeaves;
    public static ILeavesProperties skyrootLeavesProperties;
    public static ILeavesProperties goldenOakLeavesProperties;
    public static ILeavesProperties crystalLeavesProperties;
    public static ILeavesProperties holidayLeavesProperties;
    public static ILeavesProperties crystalFruitLeavesProperties;
    public static ILeavesProperties holidayDecorLeavesProperties;
    public static BlockFruit blockWhiteApple;
    public static BlockRootyDirt rootyDirtAether;
    public static ArrayList<TreeFamily> trees;
    public static String AETHERLIKE;
    public static boolean lostAetherLoaded;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        DirtHelper.createNewAdjective((String)AETHERLIKE);
        lostAetherLoaded = Loader.isModLoaded((String)"lost_aether");
        IForgeRegistry registry = event.getRegistry();
        blockWhiteApple = new BlockFruit("fruitwhiteapple");
        registry.register((IForgeRegistryEntry)blockWhiteApple);
        crystalLeaves = new BlockDynamicLeavesCrystal();
        registry.register((IForgeRegistryEntry)crystalLeaves);
        aetherLeaves = new BlockDynamicLeavesAether();
        registry.register((IForgeRegistryEntry)aetherLeaves);
        rootyDirtAether = new BlockRootyDirt("rootydirtaether", false);
        registry.register((IForgeRegistryEntry)rootyDirtAether);
        skyrootLeavesProperties = ModContent.setUpLeaves(ALTreeSkyroot.leavesBlock, ALTreeSkyroot.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockAetherLeaves.leaf_type, (Comparable)EnumLeafType.Green).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "deciduous", 4, 13);
        goldenOakLeavesProperties = ModContent.setUpLeaves(ALTreeGoldenOak.leavesBlock, ALTreeGoldenOak.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockAetherLeaves.leaf_type, (Comparable)EnumLeafType.Golden).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "deciduous", 4, 13);
        crystalLeavesProperties = ModContent.setUpLeaves(ALTreeCrystal.leavesBlock, ALTreeCrystal.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockCrystalLeaves.leaf_type, (Comparable)EnumCrystalType.Crystal).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "conifer", 4, 13);
        crystalFruitLeavesProperties = ModContent.setUpLeaves(ALTreeCrystal.leavesBlock, ALTreeCrystal.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockCrystalLeaves.leaf_type, (Comparable)EnumCrystalType.Crystal_Fruited).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "conifer", 4, 13);
        holidayLeavesProperties = ModContent.setUpLeaves(ALTreeHoliday.leavesBlock, ALTreeHoliday.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockHolidayLeaves.leaf_type, (Comparable)EnumHolidayType.Holiday_Leaves).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "conifer", 4, 4);
        holidayDecorLeavesProperties = ModContent.setUpLeaves(ALTreeHoliday.leavesBlock, ALTreeHoliday.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockHolidayLeaves.leaf_type, (Comparable)EnumHolidayType.Decorated_Leaves).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), "conifer", 4, 4);
        crystalLeavesProperties.setDynamicLeavesState(crystalLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        crystalFruitLeavesProperties.setDynamicLeavesState(crystalLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(1)));
        skyrootLeavesProperties.setDynamicLeavesState(aetherLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        goldenOakLeavesProperties.setDynamicLeavesState(aetherLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(1)));
        holidayLeavesProperties.setDynamicLeavesState(aetherLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(2)));
        holidayDecorLeavesProperties.setDynamicLeavesState(aetherLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(3)));
        crystalLeaves.setProperties(0, crystalLeavesProperties);
        crystalLeaves.setProperties(1, crystalFruitLeavesProperties);
        aetherLeaves.setProperties(0, skyrootLeavesProperties);
        aetherLeaves.setProperties(1, goldenOakLeavesProperties);
        aetherLeaves.setProperties(2, holidayLeavesProperties);
        aetherLeaves.setProperties(3, holidayDecorLeavesProperties);
        ALTreeSkyroot skyrootTree = new ALTreeSkyroot();
        ALTreeGoldenOak goldenOakTree = new ALTreeGoldenOak();
        ALTreeCrystal crystalTree = new ALTreeCrystal();
        ALTreeHoliday holidayTree = new ALTreeHoliday();
        Collections.addAll(trees, new TreeFamily[]{skyrootTree, goldenOakTree, crystalTree, holidayTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreestheaether").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
        DirtHelper.registerSoil((Block)BlocksAether.aether_grass, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlocksAether.enchanted_aether_grass, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlocksAether.aether_dirt, (String)"dirtlike");
        DirtHelper.registerSoil((Block)rootyDirtAether, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BlocksAether.aether_grass, (String)AETHERLIKE);
        DirtHelper.registerSoil((Block)BlocksAether.enchanted_aether_grass, (String)AETHERLIKE);
        DirtHelper.registerSoil((Block)BlocksAether.aether_dirt, (String)AETHERLIKE);
        DirtHelper.registerSoil((Block)rootyDirtAether, (String)AETHERLIKE);
    }

    private static ILeavesProperties setUpLeaves(final Block leavesBlock, final IBlockState leavesState, String cellKit, final int smother, final int light) {
        LeavesProperties leavesProperties = new LeavesProperties(leavesState, new ItemStack(leavesBlock, 1, leavesBlock.func_176201_c(leavesState)), TreeRegistry.findCellKit((String)cellKit)){

            public int getSmotherLeavesMax() {
                return smother;
            }

            public int getLightRequirement() {
                return light;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(leavesBlock, 1, leavesBlock.func_176201_c(leavesState));
            }
        };
        return leavesProperties;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setUpSeedRecipes("skyroot", new ItemStack(ALTreeSkyroot.saplingBlock));
        ModContent.setUpSeedRecipes("goldenoak", new ItemStack(ALTreeGoldenOak.saplingBlock));
        if (lostAetherLoaded) {
            Block crystalSapling = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("lost_aether", "crystal_sapling"));
            assert (crystalSapling != null);
            ModContent.setUpSeedRecipes("crystal", new ItemStack(crystalSapling), new ItemStack(ItemsAether.white_apple));
        }
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestheaether", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling, ItemStack fruit) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestheaether", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipesWithFruit((ItemStack)treeSapling, (ItemStack)treeSeed, (ItemStack)fruit, (boolean)true, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreestheaether").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
        ModelLoader.setCustomStateMapper((Block)crystalLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)aetherLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)rootyDirtAether, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
    }

    static {
        trees = new ArrayList();
        AETHERLIKE = "aetherlike";
    }
}

