/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.helper;

import com.fuzs.letmesleep.LetMeSleep;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ReflectionHelper {
    private static final String ENTITYPLAYER_BED_IN_RANGE = "func_190774_a";
    private static final String ENTITYPLAYER_SPAWN_SHOULDER_ENTITIES = "func_192030_dh";
    private static final String ENTITYPLAYER_SET_SIZE = "func_70105_a";
    private static final String ENTITYPLAYER_SLEEPING = "field_71083_bS";
    private static final String ENTITYPLAYER_SLEEP_TIMER = "field_71076_b";
    private static final String ENTITYLIVINGBASE_ON_FINISHED_POTION_EFFECT = "func_70688_c";
    private static final String WORLDSERVER_WAKE_ALL_PLAYERS = "func_73053_d";
    private static final String GUICHAT_INPUT_FIELD = "field_146415_a";
    private static final String GUINEWCHAT_CHAT_LINES = "field_146252_h";
    private static final String GUINEWCHAT_DRAWN_CHAT_LINES = "field_146253_i";

    public static Method getBedInRange() {
        try {
            return ObfuscationReflectionHelper.findMethod(EntityPlayer.class, (String)ENTITYPLAYER_BED_IN_RANGE, Boolean.TYPE, (Class[])new Class[]{BlockPos.class, EnumFacing.class});
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getBedInRange() failed", (Throwable)e);
            return null;
        }
    }

    public static Method getSpawnShoulderEntities() {
        try {
            return ObfuscationReflectionHelper.findMethod(EntityPlayer.class, (String)ENTITYPLAYER_SPAWN_SHOULDER_ENTITIES, Void.TYPE, (Class[])new Class[0]);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getSpawnShoulderEntities() failed", (Throwable)e);
            return null;
        }
    }

    public static Method getSetSize() {
        try {
            return ObfuscationReflectionHelper.findMethod(Entity.class, (String)ENTITYPLAYER_SET_SIZE, Void.TYPE, (Class[])new Class[]{Float.TYPE, Float.TYPE});
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getSetSize() failed", (Throwable)e);
            return null;
        }
    }

    public static void setSleeping(EntityPlayer instance, boolean flag) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)instance, (Object)flag, (String)ENTITYPLAYER_SLEEPING);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("setSleeping() failed", (Throwable)e);
        }
    }

    public static void setSleepTimer(EntityPlayer instance, int i) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)instance, (Object)i, (String)ENTITYPLAYER_SLEEP_TIMER);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("resetSleepTimer() failed", (Throwable)e);
        }
    }

    public static Method getOnFinishedPotionEffect() {
        try {
            return ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)ENTITYLIVINGBASE_ON_FINISHED_POTION_EFFECT, Void.TYPE, (Class[])new Class[]{PotionEffect.class});
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getOnFinishedPotionEffect() failed", (Throwable)e);
            return null;
        }
    }

    public static Method getWakeAllPlayers() {
        try {
            return ObfuscationReflectionHelper.findMethod(WorldServer.class, (String)WORLDSERVER_WAKE_ALL_PLAYERS, Void.TYPE, (Class[])new Class[0]);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getWakeAllPlayers() failed", (Throwable)e);
            return null;
        }
    }

    public static GuiTextField getInputField(GuiChat instance) {
        try {
            return (GuiTextField)ObfuscationReflectionHelper.getPrivateValue(GuiChat.class, (Object)instance, (String)GUICHAT_INPUT_FIELD);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getInputField() failed", (Throwable)e);
            return null;
        }
    }

    public static List<ChatLine> getChatLines(GuiNewChat instance) {
        try {
            return (List)ObfuscationReflectionHelper.getPrivateValue(GuiNewChat.class, (Object)instance, (String)GUINEWCHAT_CHAT_LINES);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getChatLines() failed", (Throwable)e);
            return null;
        }
    }

    public static List<ChatLine> getDrawnChatLines(GuiNewChat instance) {
        try {
            return (List)ObfuscationReflectionHelper.getPrivateValue(GuiNewChat.class, (Object)instance, (String)GUINEWCHAT_DRAWN_CHAT_LINES);
        }
        catch (Exception e) {
            LetMeSleep.LOGGER.error("getDrawnChatLines() failed", (Throwable)e);
            return null;
        }
    }
}

