/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.handler;

import com.fuzs.letmesleep.handler.ConfigBuildHandler;
import com.fuzs.letmesleep.helper.ReflectionHelper;
import com.fuzs.letmesleep.helper.SetSpawnHelper;
import com.fuzs.letmesleep.helper.TimeFormatHelper;
import com.fuzs.letmesleep.util.SetSpawnPoint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SleepAttemptHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerSleep(PlayerSleepInBedEvent evt) {
        EnumFacing facing;
        EntityPlayer player = evt.getEntityPlayer();
        World world = player.field_70170_p;
        BlockPos at = evt.getPos();
        BlockPos spawn = player.getBedLocation(player.field_71093_bK);
        IBlockState state = world.func_175667_e(at) ? world.func_180495_p(at) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)world, at, (Entity)player);
        EnumFacing enumFacing = facing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        if (!world.field_72995_K) {
            List list;
            if (evt.getResultStatus() != null) {
                return;
            }
            if (player.func_70608_bn() || !player.func_70089_S()) {
                evt.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            if (!world.field_73011_w.func_76569_d()) {
                evt.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
                return;
            }
            if (ConfigBuildHandler.sleepConfig.rangeCheck && !this.bedInRange(player, at, facing)) {
                evt.setResult(EntityPlayer.SleepResult.TOO_FAR_AWAY);
                return;
            }
            if (ConfigBuildHandler.sleepConfig.obstructionCheck && facing != null && this.bedObstructed(player, at, facing)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.obstructed", new Object[0]), true);
                evt.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            if (SetSpawnHelper.isNewSpawnAllowed(world, player, at, SetSpawnPoint.INTERACT) && !player.func_70093_af()) {
                player.func_180473_a(at, false);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((EntityPlayer)player, (BlockPos)at)) {
                this.sendNotPossibleNowMessage(player);
                evt.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            if (ConfigBuildHandler.sleepConfig.monsterCheck && !player.func_184812_l_() && !(list = player.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB((double)at.func_177958_n() - 8.0, (double)at.func_177956_o() - 5.0, (double)at.func_177952_p() - 8.0, (double)at.func_177958_n() + 8.0, (double)at.func_177956_o() + 5.0, (double)at.func_177952_p() + 8.0), it -> {
                if (it != null) {
                    boolean name = ConfigBuildHandler.sleepConfig.namedMonsters || !it.func_145818_k_();
                    boolean persistent = ConfigBuildHandler.sleepConfig.persistentMonsters || !it.func_104002_bU();
                    return it.func_191990_c(player) && name && persistent && it.func_70089_S();
                }
                return false;
            })).isEmpty()) {
                if (ConfigBuildHandler.sleepConfig.glow) {
                    list.forEach(it -> it.func_70690_d(new PotionEffect(MobEffects.field_188423_x, ConfigBuildHandler.sleepConfig.glowDuration)));
                }
                evt.setResult(EntityPlayer.SleepResult.NOT_SAFE);
                return;
            }
            if (!ConfigBuildHandler.sleepTimingsConfig.instantSleeping && SetSpawnHelper.isNewSpawnAllowed(world, player, at, SetSpawnPoint.CHAT)) {
                player.func_146105_b((ITextComponent)SetSpawnHelper.createRespawnMessage(), false);
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        this.spawnShoulderEntities(player);
        this.setSize(player, 0.2f, 0.2f);
        if (facing != null) {
            float f1 = 0.5f + (float)facing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)facing.func_82599_e() * 0.4f;
            player.field_71079_bU = -1.8f * (float)facing.func_82601_c();
            player.field_71089_bV = -1.8f * (float)facing.func_82599_e();
            player.func_70107_b((double)((float)at.func_177958_n() + f1), (double)((float)at.func_177956_o() + 0.6875f), (double)((float)at.func_177952_p() + f));
        } else {
            player.func_70107_b((double)((float)at.func_177958_n() + 0.5f), (double)((float)at.func_177956_o() + 0.6875f), (double)((float)at.func_177952_p() + 0.5f));
        }
        ReflectionHelper.setSleeping(player, true);
        ReflectionHelper.setSleepTimer(player, ConfigBuildHandler.sleepTimingsConfig.instantSleeping ? 100 : 0);
        player.field_71081_bT = at;
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        evt.setResult(EntityPlayer.SleepResult.OK);
    }

    private boolean bedInRange(EntityPlayer player, BlockPos pos, EnumFacing facing) {
        Method bedInRange = ReflectionHelper.getBedInRange();
        if (bedInRange != null) {
            try {
                return (Boolean)bedInRange.invoke((Object)player, pos, facing);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void spawnShoulderEntities(EntityPlayer player) {
        Method spawnShoulderEntities = ReflectionHelper.getSpawnShoulderEntities();
        if (spawnShoulderEntities != null) {
            try {
                spawnShoulderEntities.invoke((Object)player, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean bedObstructed(EntityPlayer player, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos1 = pos.func_177984_a();
        BlockPos blockpos2 = blockpos1.func_177972_a(facing.func_176734_d());
        boolean flag1 = player.field_70170_p.func_180495_p(blockpos1).func_191058_s();
        boolean flag2 = player.field_70170_p.func_180495_p(blockpos2).func_191058_s();
        return flag1 || flag2;
    }

    private void setSize(EntityPlayer player, float width, float height) {
        Method setSize = ReflectionHelper.getSetSize();
        if (setSize != null) {
            try {
                setSize.invoke((Object)player, Float.valueOf(width), Float.valueOf(height));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendNotPossibleNowMessage(EntityPlayer player) {
        int min = ConfigBuildHandler.sleepTimingsConfig.bedtimeStart;
        int max = ConfigBuildHandler.sleepTimingsConfig.bedtimeEnd;
        String minTime = TimeFormatHelper.formatTime(min);
        String maxTime = TimeFormatHelper.formatTime(max);
        boolean thunder = ConfigBuildHandler.sleepTimingsConfig.bedtimeThunder;
        boolean rain = ConfigBuildHandler.sleepTimingsConfig.bedtimeRain;
        Optional<TextComponentTranslation> weather = Optional.empty();
        TextComponentTranslation time = min == 12541 && max == 23458 ? new TextComponentTranslation("block.minecraft.bed.no_sleep.night", new Object[0]) : new TextComponentTranslation("block.minecraft.bed.no_sleep.time", new Object[]{minTime, maxTime});
        if (thunder && rain) {
            weather = Optional.of(new TextComponentTranslation("block.minecraft.bed.no_sleep.bad_weather", new Object[0]));
        } else if (thunder) {
            weather = Optional.of(new TextComponentTranslation("block.minecraft.bed.no_sleep.thunder", new Object[0]));
        } else if (rain) {
            weather = Optional.of(new TextComponentTranslation("block.minecraft.bed.no_sleep.rain", new Object[0]));
        }
        TextComponentTranslation message = weather.map(it -> new TextComponentTranslation("block.minecraft.bed.no_sleep.long_message", new Object[]{time, it})).orElseGet(() -> new TextComponentTranslation("block.minecraft.bed.no_sleep.short_message", new Object[]{time}));
        player.func_146105_b((ITextComponent)message, true);
    }
}

