/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.paths.event;

import com.tfar.paths.Paths;
import com.tfar.paths.config.BlockConfigHandler;
import com.tfar.paths.config.PathValue;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="paths")
public class EventPlayerTick {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && event.phase == TickEvent.Phase.START) {
            BlockPos pos = player.func_180425_c();
            double playerY = player.field_70163_u;
            IAttributeInstance attributeInstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            PathValue pathValue = null;
            int iter = 0;
            boolean hasLOS = true;
            while (iter < 8 && pathValue == null) {
                int meta;
                IBlockState state;
                Block block;
                if ((pathValue = BlockConfigHandler.MODIFIER_MAP.get(Pair.of((Object)(block = (state = world.func_180495_p(pos.func_177979_c(++iter))).func_177230_c()), (Object)(meta = state.func_177230_c().func_176201_c(state))))) != null || state.func_185890_d((IBlockAccess)world, pos) == null) continue;
                hasLOS = false;
            }
            if (pathValue != null) {
                BlockPos pathPos = pos.func_177979_c(iter);
                int maxDistance = pathValue.maxDistance();
                boolean requiresLoS = pathValue.requiresLineOfSight();
                double distance = playerY - (double)pathPos.func_177956_o();
                if (distance <= (double)maxDistance && (!requiresLoS || hasLOS)) {
                    double modify = Math.max(pathValue.speedMultiplier() - 1.0, -0.9375);
                    EventPlayerTick.safeAddAttributeModifier((EntityLivingBase)player, SharedMonsterAttributes.field_111263_d, new AttributeModifier(Paths.MODIFIER_UUID, "Path Modifier", modify, 1).func_111168_a(false));
                } else {
                    attributeInstance.func_188479_b(Paths.MODIFIER_UUID);
                }
            } else {
                attributeInstance.func_188479_b(Paths.MODIFIER_UUID);
            }
        }
    }

    public static void safeAddAttributeModifier(EntityLivingBase living, IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance entityAttribute = living.func_110148_a(attribute);
        if (entityAttribute.func_111127_a(modifier.func_111167_a()) != null) {
            entityAttribute.func_188479_b(modifier.func_111167_a());
        }
        entityAttribute.func_111121_a(modifier);
    }
}

