/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.paths.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tfar.paths.Paths;
import com.tfar.paths.config.BlockConfigDefault;
import com.tfar.paths.config.BlockConfigNestedEntry;
import com.tfar.paths.config.PathValue;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BlockConfigHandler {
    public static final String LOCATION = "config/paths.json";
    public static final Map<Pair<Block, Integer>, PathValue> MODIFIER_MAP = new HashMap<Pair<Block, Integer>, PathValue>();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<PathValue, List<BlockConfigNestedEntry>> CONFIGS = new HashMap<PathValue, List<BlockConfigNestedEntry>>();

    public static void handle() {
        File file = new File(LOCATION);
        if (!file.exists()) {
            BlockConfigHandler.writeDefaultConfig();
        }
        BlockConfigHandler.load();
    }

    public static void writeDefaultConfig() {
        Paths.LOGGER.info("Block config file not found, writing defaults");
        try {
            FileWriter writer = new FileWriter(LOCATION);
            writer.write(BlockConfigDefault.defaults);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        Paths.LOGGER.info("Loading entries from block config file");
        try {
            CONFIGS.clear();
            FileReader reader = new FileReader(LOCATION);
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            json.entrySet().forEach(stringJsonElementEntry -> {
                ArrayList blocks = new ArrayList();
                ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().entrySet().forEach(jsonElement -> {
                    try {
                        String s = (String)jsonElement.getKey();
                        ResourceLocation rl = new ResourceLocation(s);
                        if (Loader.isModLoaded((String)rl.func_110624_b())) {
                            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
                            if (block == null || block == Blocks.field_150350_a) {
                                Paths.LOGGER.error("{} may not exist or is not a valid block", (Object)s);
                            } else {
                                JsonArray jsonArray = ((JsonElement)jsonElement.getValue()).getAsJsonArray();
                                ArrayList list = new ArrayList();
                                jsonArray.forEach(jsonElement1 -> list.add(jsonElement1.getAsInt()));
                                blocks.add(new BlockConfigNestedEntry(block, list.toArray(new Integer[0])));
                                Paths.LOGGER.debug("Successfully added {} to the block list", (Object)block.getRegistryName());
                            }
                        }
                    }
                    catch (Exception e) {
                        Paths.LOGGER.error("{} - {}", (Object)e, (Object)jsonElement.toString());
                    }
                });
                String[] strings = ((String)stringJsonElementEntry.getKey()).split(",");
                double multi = Double.parseDouble(strings[0]);
                int distance = Integer.parseInt(strings[1]);
                boolean lineOfSight = Boolean.parseBoolean(strings[2]);
                CONFIGS.put(new PathValue(multi, distance, lineOfSight), blocks);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MODIFIER_MAP.clear();
        CONFIGS.forEach((pathValue, nestedConfigEntries) -> nestedConfigEntries.forEach(nestedConfigEntry -> {
            if (nestedConfigEntry.meta != null && nestedConfigEntry.meta.length > 0) {
                Arrays.stream(nestedConfigEntry.meta).forEach(meta -> MODIFIER_MAP.put((Pair<Block, Integer>)Pair.of((Object)nestedConfigEntry.block, (Object)meta), (PathValue)pathValue));
            } else {
                IntStream.range(0, 16).forEach(i -> MODIFIER_MAP.put((Pair<Block, Integer>)Pair.of((Object)nestedConfigEntry.block, (Object)i), (PathValue)pathValue));
            }
        }));
    }
}

