/*
 * Decompiled with CFR 0.152.
 */
package com.eksekk.fireresistancetiers.handlers;

import com.eksekk.fireresistancetiers.config.ConfigFields;
import com.eksekk.fireresistancetiers.handlers.EntityAttackHandler;
import com.eksekk.fireresistancetiers.handlers.PlayerAttackHandler;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class EventHandlers {
    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) throws IllegalAccessException, InvocationTargetException {
        if (!event.getSource().func_76347_k() || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        PotionEffect effect = entity.func_70660_b(MobEffects.field_76426_n);
        if (effect == null) {
            return;
        }
        if (effect.func_76458_c() + 1 >= ConfigFields.numberOfTiers) {
            return;
        }
        float damage = event.getAmount() * (1.0f - (float)(effect.func_76458_c() + 1) / (float)ConfigFields.numberOfTiers);
        if (entity instanceof EntityPlayer) {
            PlayerAttackHandler.attackEntityFrom((EntityPlayer)entity, event.getSource(), damage);
        } else {
            EntityAttackHandler.attackEntityFrom(entity, event.getSource(), damage);
        }
    }

    @SubscribeEvent
    public static void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        IForgeRegistry registry = event.getRegistry();
        PotionEffect normal = new PotionEffect(MobEffects.field_76426_n, 3600, ConfigFields.potionAmplifier);
        PotionEffect long_ = new PotionEffect(MobEffects.field_76426_n, 9600, ConfigFields.potionAmplifier);
        PotionEffect strong = new PotionEffect(MobEffects.field_76426_n, 1800, ConfigFields.strongPotionAmplifier);
        registry.registerAll((IForgeRegistryEntry[])new PotionType[]{(PotionType)new PotionType("fire_resistance", new PotionEffect[]{normal}).setRegistryName("minecraft:fire_resistance"), (PotionType)new PotionType("fire_resistance", new PotionEffect[]{long_}).setRegistryName("minecraft:long_fire_resistance"), (PotionType)new PotionType("fire_resistance", new PotionEffect[]{strong}).setRegistryName("strong_fire_resistance")});
        if (ConfigFields.strongPotionAmplifier > ConfigFields.potionAmplifier) {
            PotionHelper.func_193357_a((PotionType)PotionTypes.field_185241_m, (Item)Item.func_111206_d((String)"glowstone_dust"), (PotionType)((PotionType)registry.getValue(new ResourceLocation("fireresistancetiers", "strong_fire_resistance"))));
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("fireresistancetiers")) {
            ConfigManager.sync((String)"fireresistancetiers", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

