/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util.unsafe;

import com.personthecat.orestonevariants.util.interfaces.ThrowingBiConsumer;
import com.personthecat.orestonevariants.util.interfaces.ThrowingBiFunction;
import com.personthecat.orestonevariants.util.interfaces.ThrowingSupplier;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Value;
import com.personthecat.orestonevariants.util.unsafe.Void;

class WithResources<R1 extends AutoCloseable, R2 extends AutoCloseable, E extends Throwable> {
    private final ThrowingSupplier<R1, E> r1Getter;
    private final ThrowingSupplier<R2, E> r2Getter;

    WithResources(ThrowingSupplier<R1, E> r1Getter, ThrowingSupplier<R2, E> r2Getter) {
        this.r1Getter = r1Getter;
        this.r2Getter = r2Getter;
    }

    public <T, E2 extends Throwable> Result<T, E2> of(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        return new Result(() -> this.getResult(attempt));
    }

    public <E2 extends Throwable> Result<Void, E2> of(ThrowingBiConsumer<R1, R2, E2> attempt) {
        return this.of((R1 r1, R2 r2) -> {
            attempt.accept(r1, r2);
            return Void.INSTANCE;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, E2 extends Throwable> Value<T, E2> getResult(ThrowingBiFunction<R1, R2, T, E2> attempt) {
        try (AutoCloseable r1 = (AutoCloseable)this.r1Getter.get();){
            Value value;
            block14: {
                AutoCloseable r2 = (AutoCloseable)this.r2Getter.get();
                try {
                    value = Value.ok(attempt.apply(r1, r2));
                    if (r2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (r2 != null) {
                        try {
                            r2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r2.close();
            }
            return value;
        }
        catch (Throwable e) {
            return Value.err(Result.errorFound(e));
        }
    }
}

