/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util.unsafe;

import com.personthecat.orestonevariants.util.interfaces.ThrowingConsumer;
import com.personthecat.orestonevariants.util.interfaces.ThrowingFunction;
import com.personthecat.orestonevariants.util.interfaces.ThrowingSupplier;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Value;
import com.personthecat.orestonevariants.util.unsafe.Void;
import com.personthecat.orestonevariants.util.unsafe.WithResources;

public class WithResource<R extends AutoCloseable, E extends Throwable> {
    private final ThrowingSupplier<R, E> rGetter;

    WithResource(ThrowingSupplier<R, E> rGetter) {
        this.rGetter = rGetter;
    }

    public <T, E2 extends Throwable> Result<T, E2> of(ThrowingFunction<R, T, E2> attempt) {
        return new Result(() -> this.getResult(attempt));
    }

    public <E2 extends Throwable> Result<Void, E2> of(ThrowingConsumer<R, E2> attempt) {
        return this.of((R r) -> {
            attempt.accept(r);
            return Void.INSTANCE;
        });
    }

    public <R2 extends AutoCloseable> WithResources<R, R2, E> with(ThrowingSupplier<R2, E> resource) {
        return new WithResources<R, R2, E>(this.rGetter, resource);
    }

    public <R2 extends AutoCloseable> WithResources<R, R2, E> with(ThrowingFunction<R, R2, E> getter) {
        return new WithResources<R, AutoCloseable, E>(this.rGetter, () -> (AutoCloseable)getter.apply((AutoCloseable)this.rGetter.get()));
    }

    private <T, E2 extends Throwable> Value<T, E2> getResult(ThrowingFunction<R, T, E2> attempt) {
        Value value;
        block8: {
            AutoCloseable r = (AutoCloseable)this.rGetter.get();
            try {
                value = Value.ok(attempt.apply(r));
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return Value.err(Result.errorFound(e));
                }
            }
            r.close();
        }
        return value;
    }
}

