/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util.unsafe;

import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.interfaces.ThrowingConsumer;
import com.personthecat.orestonevariants.util.interfaces.ThrowingFunction;
import com.personthecat.orestonevariants.util.interfaces.ThrowingRunnable;
import com.personthecat.orestonevariants.util.interfaces.ThrowingSupplier;
import com.personthecat.orestonevariants.util.unsafe.Protocol;
import com.personthecat.orestonevariants.util.unsafe.Value;
import com.personthecat.orestonevariants.util.unsafe.Void;
import com.personthecat.orestonevariants.util.unsafe.WithResource;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Result<T, E extends Throwable> {
    private final Lazy<Value<T, E>> value;

    public static <E extends Throwable> void IGNORE(E e) {
    }

    public static <E extends Throwable> void WARN(E e) {
        CommonMethods.warn("{}", e);
    }

    public static <E extends Throwable> void THROW(E e) {
        throw CommonMethods.runEx(e);
    }

    Result(Supplier<Value<T, E>> attempt) {
        this.value = new Lazy<Supplier<Value<T, E>>>(attempt);
    }

    Result(Value<T, E> value) {
        this.value = new Lazy<Value<Value<T, E>, E>>(value);
    }

    public static <E extends Throwable> Result<Void, E> ok() {
        return Handled.OK;
    }

    public static <T, E extends Throwable> Result<T, E> ok(T val) {
        return new Handled(Value.ok(val));
    }

    public static <T, E extends Throwable> Result<T, E> err(E e) {
        return new Handled(Value.err(e));
    }

    public static <T, E extends Throwable> Result<T, E> of(ThrowingSupplier<T, E> attempt) {
        return new Result<T, E>(() -> Result.getResult(attempt));
    }

    public static <E extends Throwable> Result<Void, E> of(ThrowingRunnable<E> attempt) {
        return new Result(() -> Result.getResult(attempt));
    }

    public static <T, E extends Throwable> Result<Optional<T>, E> nullable(ThrowingSupplier<T, E> attempt) {
        return new Result<T, E>(() -> Result.getResult(() -> Optional.ofNullable(attempt.get())));
    }

    public static <R extends AutoCloseable, E extends Throwable> WithResource<R, E> with(ThrowingSupplier<R, E> resource) {
        return new WithResource<R, E>(resource);
    }

    public static <R extends AutoCloseable, T, E extends Throwable> Result<T, E> with(ThrowingSupplier<R, E> resource, ThrowingFunction<R, T, E> attempt) {
        return Result.with(resource).of(attempt);
    }

    public static <R extends AutoCloseable, E extends Throwable> Result<Void, E> with(ThrowingSupplier<R, E> resource, ThrowingConsumer<R, E> attempt) {
        return Result.with(resource).of(attempt);
    }

    public static <E extends Exception> Protocol define(Class<E> clazz, Consumer<E> func) {
        return new Protocol().define(clazz, func);
    }

    @SafeVarargs
    public static <E extends Throwable> Result<Void, E> join(Result<Void, E> ... results) {
        return Result.of(() -> {
            for (Result result : results) {
                result.throwIfErr();
            }
        });
    }

    public boolean isErr() {
        return this.getErr().isPresent();
    }

    public Result<T, E> ifErr(Consumer<E> func) {
        try {
            this.getErr().ifPresent(func);
        }
        catch (ClassCastException e) {
            throw Result.wrongErrorFound(this.unwrapErr());
        }
        return this.handled();
    }

    public boolean isOk() {
        return this.getVal().isPresent();
    }

    public Result<T, E> ifOk(Consumer<T> func) {
        this.getVal().ifPresent(func);
        return this.isOk() ? this.handled() : this;
    }

    public Optional<T> get(Consumer<E> func) {
        return super.getVal();
    }

    public Optional<T> get() {
        this.errorCheck();
        return this.getVal();
    }

    private Optional<T> getVal() {
        return this.value.get().result;
    }

    public Optional<E> getErr() {
        return this.value.get().err;
    }

    public T unwrap() {
        return this.expect("Attempted to unwrap a result with no value.");
    }

    public E unwrapErr() {
        return this.expectErr("Attempted to unwrap a result with no error.");
    }

    public T expect(String message) {
        return super.getVal().orElse(null);
    }

    public T expectF(String message, Object ... args) {
        return this.expect(CommonMethods.f(message, args));
    }

    public E expectErr(String message) {
        return (E)((Throwable)this.ifOk(t -> {
            throw CommonMethods.runEx(message);
        }).getErr().orElse(null));
    }

    public E expectErrF(String message, Object ... args) {
        return this.expectErr(CommonMethods.f(message, args));
    }

    public T throwIfErr() throws E {
        Result.throwIfPresent(this.getErr());
        return this.unwrap();
    }

    public <M> Result<M, E> map(Function<T, M> func) {
        Optional<M> mapped = this.getVal().map(func);
        Optional<E> err = this.getErr();
        return new Result<M, E>(new Value<M, E>(mapped, err));
    }

    public <E2 extends Throwable> Result<T, E2> mapErr(Function<E, E2> func) {
        Optional<T> val = this.getVal();
        Optional<E2> mapped = this.getErr().map(func);
        return new Handled<T, E2>(new Value<T, E2>(val, mapped));
    }

    public Result<T, E> orElseTry(ThrowingFunction<E, T, E> func) {
        return this.getErr().map((? super T e) -> Result.of(() -> func.apply(e))).orElse(this.handled());
    }

    public Result<T, E> andThen(Function<T, Result<T, E>> func) {
        return this.getVal().map(func).orElse(this);
    }

    public T orElse(T val) {
        this.errorCheck();
        return this.getVal().orElse(val);
    }

    public T orElseGet(Function<E, T> func) {
        try {
            return this.getErr().map(func).orElse(this.unwrap());
        }
        catch (ClassCastException e) {
            throw Result.wrongErrorFound(this.unwrapErr());
        }
    }

    public T orElseGet(Supplier<T> func) {
        this.errorCheck();
        return this.isErr() ? func.get() : this.unwrap();
    }

    private <U> Optional<Result<U, E>> transpose() {
        if (this.isErr()) {
            return CommonMethods.full(Result.err(this.unwrapErr()));
        }
        if (this.unwrap() instanceof Optional) {
            return ((Optional)this.unwrap()).map(Result::ok);
        }
        throw CommonMethods.runEx("Underlying value not wrapped in Optional<U>.");
    }

    protected void errorCheck() {
        if (this.isErr()) {
            throw CommonMethods.runExF("Unhandled error in wrapper: {}", this.unwrapErr());
        }
    }

    private Handled<T, E> handled() {
        return new Handled<T, E>(this.value.get());
    }

    private static <T, E extends Throwable> Value<T, E> getResult(ThrowingSupplier<T, E> attempt) {
        try {
            return Value.ok(attempt.get());
        }
        catch (Throwable e) {
            return Value.err(Result.errorFound(e));
        }
    }

    private static <E extends Throwable> Value<Void, E> getResult(ThrowingRunnable<E> attempt) {
        return Result.getResult(() -> {
            attempt.run();
            return Void.INSTANCE;
        });
    }

    protected static <E extends Throwable> E errorFound(Throwable err) {
        try {
            return (E)err;
        }
        catch (ClassCastException e) {
            throw Result.wrongErrorFound(err);
        }
    }

    private static RuntimeException wrongErrorFound(Throwable err) {
        CommonMethods.error("Unable to handle error in wrapper: {}", err);
        return CommonMethods.runEx("Wrong type of error caught by wrapper.");
    }

    private static <E extends Throwable> void throwIfPresent(Optional<E> err) throws E {
        if (err.isPresent()) {
            throw (Throwable)err.get();
        }
    }

    public static class Handled<T, E extends Throwable>
    extends Result<T, E> {
        private static final Handled<Void, ?> OK = new Handled(Value.ok());

        Handled(Value<T, E> result) {
            super(result);
        }

        @Override
        protected void errorCheck() {
        }
    }
}

