/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util.unsafe;

import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.interfaces.ThrowingSupplier;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Value;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class Protocol {
    private Set<Procedure<? extends Exception>> procedures = new HashSet<Procedure<? extends Exception>>();

    public <E extends Exception> Protocol define(Class<E> type, Consumer<E> func) {
        this.procedures.add(new Procedure<E>(type, func));
        return this;
    }

    public <T> Result<T, Exception> of(ThrowingSupplier<T, Exception> attempt) {
        return new Result.Handled<T, Exception>(this.getResult(attempt));
    }

    private <T> Value<T, Exception> getResult(ThrowingSupplier<T, Exception> attempt) {
        try {
            return Value.ok(attempt.get());
        }
        catch (Exception e) {
            if (this.tryHandle(e)) {
                return Value.err(e);
            }
            throw CommonMethods.runEx("No procedure defined for handling error:", e);
        }
    }

    private boolean tryHandle(Exception e) {
        return this.procedures.stream().anyMatch(proc -> {
            if (proc.clazz.isInstance(e)) {
                proc.func.accept(this.cast(e));
                return true;
            }
            return false;
        });
    }

    private <E extends Exception> E cast(Exception e) {
        return (E)e;
    }

    private static class Procedure<T> {
        final Class<T> clazz;
        final Consumer<T> func;

        Procedure(Class<T> clazz, Consumer<T> func) {
            this.clazz = clazz;
            this.func = func;
        }
    }
}

