/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.google.gson.JsonParser;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Range;
import com.personthecat.orestonevariants.util.ValueLookup;
import com.personthecat.orestonevariants.util.unsafe.Protocol;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Void;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.hjson.HjsonOptions;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;
import org.hjson.ParseException;
import org.hjson.Stringify;

public class HjsonTools {
    private static final HjsonOptions FORMATTER = new HjsonOptions().setAllowCondense(true).setAllowMultiVal(true).setCommentSpace(1).setSpace(2).setBracesSameLine(true).setOutputComments(true);

    public static Optional<JsonObject> readJson(File file) {
        return new Protocol().define(FileNotFoundException.class, Result::WARN).define(ParseException.class, Result::THROW).of(() -> JsonObject.readHjson(new FileReader(file), FORMATTER).asObject()).get();
    }

    public static Optional<JsonObject> readJson(InputStream is) {
        return new Protocol().define(IOException.class, Result::WARN).define(ParseException.class, Result::THROW).of(() -> JsonObject.readHjson(new InputStreamReader(is), FORMATTER).asObject()).get();
    }

    public static Result<Void, IOException> writeJson(JsonObject json, File file) {
        return Result.with(() -> new FileWriter(file), tw -> {
            if (CommonMethods.extension(file).equals("json")) {
                json.writeTo((Writer)tw, Stringify.FORMATTED);
            } else {
                json.writeTo((Writer)tw, FORMATTER);
            }
        });
    }

    public static JsonObject setOrAdd(JsonObject json, String field, boolean value) {
        return HjsonTools.setOrAdd(json, field, JsonValue.valueOf(value));
    }

    public static JsonObject setOrAdd(JsonObject json, String field, int value) {
        return HjsonTools.setOrAdd(json, field, JsonValue.valueOf(value));
    }

    public static JsonObject setOrAdd(JsonObject json, String field, float value) {
        return HjsonTools.setOrAdd(json, field, JsonValue.valueOf(value));
    }

    public static JsonObject setOrAdd(JsonObject json, String field, String value) {
        return HjsonTools.setOrAdd(json, field, JsonValue.valueOf(value));
    }

    public static JsonObject setOrAdd(JsonObject json, String field, JsonValue value) {
        if (json.get(field) != null) {
            return json.set(field, value);
        }
        return json.add(field, value);
    }

    public static Optional<Boolean> getBool(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(JsonValue::asBoolean);
    }

    public static void getBool(JsonObject json, String field, Consumer<Boolean> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(value.asBoolean());
        }
    }

    public static boolean getBoolOr(JsonObject json, String field, boolean orElse) {
        return HjsonTools.getBool(json, field).orElse(orElse);
    }

    public static Optional<Integer> getInt(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(JsonValue::asInt);
    }

    public static void getInt(JsonObject json, String field, Consumer<Integer> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(value.asInt());
        }
    }

    public static int getIntOr(JsonObject json, String field, int orElse) {
        return HjsonTools.getInt(json, field).orElse(orElse);
    }

    public static Optional<Range> getRange(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).map(HjsonTools::toIntArray).map(CommonMethods::sort).map(HjsonTools::toRange);
    }

    public static Range getRangeOr(JsonObject json, String field, Range orElse) {
        return HjsonTools.getRange(json, field).orElse(orElse);
    }

    private static Range toRange(int[] range) {
        return range.length == 0 ? new Range(0) : (range.length == 1 ? new Range(range[0]) : new Range(range[0], range[range.length - 1]));
    }

    public static Optional<Float> getFloat(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(JsonValue::asFloat);
    }

    public static void getFloat(JsonObject json, String field, Consumer<Float> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(Float.valueOf(value.asFloat()));
        }
    }

    public static float getFloatOr(JsonObject json, String field, float orElse) {
        return HjsonTools.getFloat(json, field).orElse(Float.valueOf(orElse)).floatValue();
    }

    public static Optional<String> getString(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(JsonValue::asString);
    }

    public static void getString(JsonObject json, String field, Consumer<String> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(value.asString());
        }
    }

    public static String getStringOr(JsonObject json, String field, String orElse) {
        return HjsonTools.getString(json, field).orElse(orElse);
    }

    public static String getGuaranteedString(JsonObject json, String field) {
        return HjsonTools.getString(json, field).orElseThrow(() -> CommonMethods.runExF("Missing field: {}", field));
    }

    public static Optional<JsonArray> getArray(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(HjsonTools::asOrToArray);
    }

    public static JsonArray getArrayOr(JsonObject json, String field, JsonArray orElse) {
        return HjsonTools.getArray(json, field).orElse(orElse);
    }

    public static JsonArray getArrayOrNew(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).orElse(new JsonArray());
    }

    private static JsonArray asOrToArray(JsonValue value) {
        return value.isArray() ? value.asArray() : new JsonArray().add(value);
    }

    public static void getArray(JsonObject json, String field, Consumer<JsonArray> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(value.asArray());
        }
    }

    public static Optional<JsonObject> getObject(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(JsonValue::asObject);
    }

    public static JsonObject getObjectOr(JsonObject json, String field, JsonObject orElse) {
        return HjsonTools.getObject(json, field).orElse(orElse);
    }

    public static JsonObject getObjectOrNew(JsonObject json, String field) {
        return HjsonTools.getObject(json, field).orElse(new JsonObject());
    }

    public static void getObject(JsonObject json, String field, Consumer<JsonObject> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(value.asObject());
        }
    }

    public static Optional<JsonValue> getValue(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field));
    }

    public static void getValue(JsonObject json, String field, Consumer<JsonValue> ifPresent) {
        HjsonTools.getValue(json, field).ifPresent(ifPresent);
    }

    public static List<JsonObject> getObjectArray(JsonObject json, String field) {
        ArrayList<JsonObject> array = new ArrayList<JsonObject>();
        HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).ifPresent(a -> a.forEach(e -> array.add(e.asObject())));
        return array;
    }

    public static Optional<int[]> getIntArray(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(v -> HjsonTools.toIntArray(v.asArray()));
    }

    public static void getIntArray(JsonObject json, String field, Consumer<int[]> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(HjsonTools.toIntArray(value.asArray()));
        }
    }

    public static int[] getIntArrayOr(JsonObject json, String field, int[] orElse) {
        return HjsonTools.getIntArray(json, field).orElse(orElse);
    }

    public static int[] getIntArrayOrEmpty(JsonObject json, String field) {
        return HjsonTools.getIntArrayOr(json, field, new int[0]);
    }

    public static int[] toIntArray(JsonArray array) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        Iterator<JsonValue> iter = array.iterator();
        while (iter.hasNext()) {
            ints.add(iter.next().asInt());
        }
        return ints.stream().mapToInt(i -> i).toArray();
    }

    public static Optional<List<String>> getStringArray(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(v -> HjsonTools.toStringArray(HjsonTools.asOrToArray(v)));
    }

    public static List<String> getStringArrayOrEmpty(JsonObject json, String field) {
        return HjsonTools.getStringArray(json, field).orElse(Collections.emptyList());
    }

    public static void getStringArray(JsonObject json, String field, Consumer<List<String>> ifPresent) {
        JsonValue value = json.get(field);
        if (value != null) {
            ifPresent.accept(HjsonTools.toStringArray(HjsonTools.asOrToArray(value)));
        }
    }

    public static List<String> toStringArray(JsonArray array) {
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<JsonValue> iter = array.iterator();
        while (iter.hasNext()) {
            strings.add(iter.next().asString());
        }
        return strings;
    }

    public static IBlockState getGuranteedState(JsonObject json, String requiredFor) {
        String stateName = HjsonTools.getString(json, "state").orElseThrow(() -> CommonMethods.runExF("Each %s object must contain the field \"state.\"", requiredFor));
        return CommonMethods.getBlockState(stateName).orElseThrow(() -> HjsonTools.noBlockNamed(stateName));
    }

    public static IBlockState[] getGuranteedStates(JsonObject json, String requiredFor) {
        JsonArray stateNames = HjsonTools.getArray(json, "states").orElseThrow(() -> CommonMethods.runExF("Each %s object must contain the field \"states.\"", requiredFor));
        return HjsonTools.toBlocks(stateNames);
    }

    public static Optional<IBlockState> getBlock(JsonObject json, String field) {
        return HjsonTools.getString(json, field).map(s -> CommonMethods.getBlockState(s).orElseThrow(() -> HjsonTools.noBlockNamed(s)));
    }

    public static IBlockState getBlockOr(JsonObject json, String field, IBlockState orElse) {
        return HjsonTools.getBlock(json, field).orElse(orElse);
    }

    public static Optional<IBlockState[]> getBlocks(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(HjsonTools::toBlocks);
    }

    public static void getBlocks(JsonObject json, String field, Consumer<IBlockState[]> ifPresent) {
        HjsonTools.getBlocks(json, field).ifPresent(ifPresent);
    }

    public static IBlockState[] toBlocks(JsonArray array) {
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        for (String s : HjsonTools.toStringArray(array)) {
            IBlockState state = CommonMethods.getBlockState(s).orElseThrow(() -> HjsonTools.noBlockNamed(s));
            blocks.add(state);
        }
        return blocks.toArray(new IBlockState[0]);
    }

    public static IBlockState[] getBlocksOr(JsonObject json, String field, IBlockState ... orElse) {
        return HjsonTools.getBlocks(json, field).orElse(orElse);
    }

    public static Optional<Item> getItem(JsonObject json, String field) {
        return HjsonTools.getString(json, field).map(s -> CommonMethods.getItem(s).orElseThrow(() -> HjsonTools.noItemNamed(s)));
    }

    public static Item getItemOr(JsonObject json, String field, Item orElse) {
        return HjsonTools.getItem(json, field).orElse(orElse);
    }

    public static Item getGuaranteedItem(JsonObject json, String field) {
        return HjsonTools.getItem(json, field).orElseThrow(() -> CommonMethods.runExF("The field {} must be defined.", field));
    }

    public static Optional<ItemStack> getStack(JsonObject json, String field) {
        return HjsonTools.getString(json, field).map(s -> CommonMethods.getStack(s).orElseThrow(() -> HjsonTools.noItemNamed(s)));
    }

    public static ItemStack getStackOr(JsonObject json, String field, ItemStack orElse) {
        return HjsonTools.getStack(json, field).orElse(orElse);
    }

    public static ItemStack getGuaranteedStack(JsonObject json, String field) {
        return HjsonTools.getStack(json, field).orElseThrow(() -> CommonMethods.runExF("The field {} must be defined.", field));
    }

    public static Optional<BlockPos> getPosition(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(HjsonTools::toPosition);
    }

    public static BlockPos getPositionOr(JsonObject json, String field, BlockPos orElse) {
        return HjsonTools.getPosition(json, field).orElse(orElse);
    }

    public static Optional<BlockPos[]> getPositions(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(a -> {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (JsonValue v : a) {
                positions.add(HjsonTools.toPosition(v.asArray()));
            }
            return CommonMethods.toArray(positions, BlockPos.class);
        });
    }

    public static void getPositions(JsonObject json, String field, Consumer<BlockPos[]> ifPresent) {
        HjsonTools.getPositions(json, field).ifPresent(ifPresent);
    }

    public static BlockPos[] getPositionsOr(JsonObject json, String field, BlockPos ... orElse) {
        return HjsonTools.getPositions(json, field).orElse(orElse);
    }

    public static BlockPos toPosition(JsonArray coordinates) {
        if (coordinates.size() != 3) {
            throw CommonMethods.runEx("Relative coordinates must be specified in an array of 3 elements, e.g. [0, 0, 0].");
        }
        return new BlockPos(coordinates.get(0).asInt(), coordinates.get(1).asInt(), coordinates.get(2).asInt());
    }

    public static Biome[] getAllBiomes(JsonObject json) {
        ArrayList biomes = new ArrayList();
        HjsonTools.getStringArray(json, "names").ifPresent(a -> {
            for (String s : a) {
                Biome biome = CommonMethods.getBiome(s).orElseThrow(() -> HjsonTools.noBiomeNamed(s));
                biomes.add(biome);
            }
        });
        HjsonTools.getBiomeTypes(json, "types").ifPresent(a -> {
            for (BiomeDictionary.Type t : a) {
                Collections.addAll(biomes, CommonMethods.getBiomes(t));
            }
        });
        return CommonMethods.toArray(biomes, Biome.class);
    }

    public static Optional<List<BiomeDictionary.Type>> getBiomeTypes(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field)).map(v -> HjsonTools.toBiomeTypes(v.asArray()));
    }

    public static List<BiomeDictionary.Type> toBiomeTypes(JsonArray array) {
        ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
        Iterator<JsonValue> iter = array.iterator();
        while (iter.hasNext()) {
            types.add(CommonMethods.getBiomeType(iter.next().asString()));
        }
        return types;
    }

    public static Optional<Material> getMaterial(JsonObject json, String field) {
        return HjsonTools.getString(json, field).flatMap(ValueLookup::getMaterial);
    }

    public static Material getMaterialOr(JsonObject json, String field, Material orElse) {
        return HjsonTools.getMaterial(json, field).orElse(orElse);
    }

    public static Optional<MapColor> getMapColor(JsonObject json, String field) {
        return HjsonTools.getString(json, field).flatMap(ValueLookup::getMapColor);
    }

    public static MapColor getMapColorOr(JsonObject json, String field, MapColor orElse) {
        return HjsonTools.getMapColor(json, field).orElse(orElse);
    }

    public static Optional<ResourceLocation> getLocation(JsonObject json, String field) {
        return HjsonTools.getString(json, field).map(ResourceLocation::new);
    }

    public static ResourceLocation getLocationOr(JsonObject json, String field, ResourceLocation orElse) {
        return HjsonTools.getLocation(json, field).orElse(orElse);
    }

    public static Optional<SoundType> getSoundType(JsonObject json, String field) {
        return HjsonTools.getString(json, field).flatMap(ValueLookup::getSoundType);
    }

    public static SoundType getSoundTypeOr(JsonObject json, String field, SoundType orElse) {
        return HjsonTools.getSoundType(json, field).orElse(orElse);
    }

    private static Optional<com.google.gson.JsonObject> gsonFromLocation(ResourceLocation location, String name) {
        String path = CommonMethods.f("/assets/{}/loot_tables/{}.json", location.func_110624_b(), location.func_110623_a());
        InputStream stream = SafeFileIO.getResource(path).orElseThrow(() -> HjsonTools.noTableNamed(name));
        return HjsonTools.parseGson(new InputStreamReader(stream));
    }

    private static Optional<com.google.gson.JsonObject> parseGson(Reader reader) {
        return Result.of(() -> new JsonParser().parse(reader).getAsJsonObject()).get(Result::WARN);
    }

    public static RuntimeException noBiomeNamed(String name) {
        return CommonMethods.runExF("There is no biome named \"{}.\"", name);
    }

    public static RuntimeException noDimensionNamed(String name) {
        return CommonMethods.runExF("There is no dimension named \"{}.\"", name);
    }

    public static RuntimeException noBlockNamed(String name) {
        return CommonMethods.runExF("There is no block named \"{}.\"", name);
    }

    public static RuntimeException noItemNamed(String name) {
        return CommonMethods.runExF("There is no item named \"{}.\"", name);
    }

    public static RuntimeException noMaterialNamed(String name) {
        return CommonMethods.runExF("There is no (supported) setMaterial named \"{}.\"", name);
    }

    public static RuntimeException noTableNamed(String name) {
        return CommonMethods.runExF("There is no loot table located at \"{}.\"", name);
    }
}

