/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.blocks.BlockGroup;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.properties.WorldGenProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.Reference;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

public class StoneProperties {
    public final Lazy<IBlockState> stone = new Lazy<Supplier<IBlockState>>(() -> CommonMethods.getBlockState(stoneLookup).orElseThrow(() -> HjsonTools.noBlockNamed(stoneLookup)));
    public final List<WorldGenProperties> gen;
    public static final String FOLDER = "/osv/stone/";
    public static final File DIR = new File(CommonMethods.getConfigDir() + "/osv/stone/");
    private static final List<String> ADDITIONAL_NAMES = Arrays.asList("dirt", "gravel", "TUTORIAL");

    public StoneProperties(String stoneLookup, List<WorldGenProperties> gen) {
        this.gen = gen;
    }

    public static List<String> getDefaultNames() {
        ArrayList<String> names = new ArrayList<String>(ADDITIONAL_NAMES);
        names.addAll(CommonMethods.list(BlockGroup.DefaultInfo.MINECRAFT.getNames()));
        names.remove("stone");
        return names;
    }

    private static StoneProperties fromFile(File f) {
        JsonObject root = HjsonTools.readJson(f).orElseThrow(() -> CommonMethods.runExF("Invalid hjson file: {}.", f.getPath()));
        String stoneLookup = (String)HjsonTools.getObject(root, "block").flatMap(block -> HjsonTools.getString(block, "location")).orElseThrow(() -> CommonMethods.runExF("Missing block @[{}].block.location.", f));
        return new StoneProperties(stoneLookup, WorldGenProperties.list(stoneLookup, HjsonTools.getArrayOrNew(root, "gen")));
    }

    public static Set<StoneProperties> setupStoneProperties() {
        HashSet<StoneProperties> properties = new HashSet<StoneProperties>();
        for (File f : SafeFileIO.safeListFiles(DIR)) {
            if (!Reference.VALID_EXTENSIONS.contains(CommonMethods.extension(f)) || f.getName().equals("TUTORIAL.hjson")) continue;
            properties.add(StoneProperties.fromFile(f));
        }
        return properties;
    }
}

