/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.util.HjsonTools;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class RecipeProperties {
    public final ItemStack input;
    public final ItemStack result;
    public final int time;
    public final float xp;

    public RecipeProperties(ItemStack input, ItemStack result, int time, float xp) {
        this.input = input;
        this.result = result;
        this.time = time;
        this.xp = xp;
    }

    public Item getInputItem() {
        return this.input.func_77973_b();
    }

    public static Set<RecipeProperties> setupRecipes() {
        return Main.ORE_PROPERTIES.stream().map(RecipeProperties::create).collect(Collectors.toSet());
    }

    private static RecipeProperties create(OreProperties props) {
        IBlockState fromState = props.ore.get();
        Block fromBlock = fromState.func_177230_c();
        int meta = fromBlock.func_176201_c(fromState);
        ItemStack fromStack = new ItemStack(fromBlock, 1, meta);
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        ItemStack resultStack = recipes.func_151395_a(fromStack);
        ItemStack result = HjsonTools.getStackOr(props.recipe, "result", resultStack);
        int time = HjsonTools.getIntOr(props.recipe, "time", result.func_77973_b().getItemBurnTime(resultStack));
        float xp = HjsonTools.getFloatOr(props.recipe, "xp", recipes.func_151398_b(resultStack));
        time = time < 0 ? 200 : time;
        return new RecipeProperties(fromStack, result, time, xp);
    }
}

