/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.config.ArrayTemplate;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class PropertyGroup {
    public final Set<OreProperties> properties;
    public final Optional<String> mod;
    public final String name;
    public static final Lazy<PropertyGroup> ALL = new Lazy<Supplier<PropertyGroup>>(PropertyGroup::getAllProperties);
    public static final Lazy<PropertyGroup> DEFAULT = new Lazy<Supplier<PropertyGroup>>(PropertyGroup::getDefaultProperties);

    public PropertyGroup(String name, Set<OreProperties> properties) {
        this(name, properties, CommonMethods.empty());
    }

    public PropertyGroup(String name, Set<OreProperties> properties, Optional<String> mod) {
        this.name = name;
        this.properties = properties;
        this.mod = mod;
    }

    public static Set<PropertyGroup> setupPropertyGroups() {
        HashSet<PropertyGroup> groups = new HashSet<PropertyGroup>();
        Cfg.BlockRegistryCat.propertyGroups.forEach((name, entries) -> {
            if (PropertyGroup.shouldAdd(name)) {
                groups.add(new PropertyGroup((String)name, OreProperties.of(entries)));
            }
        });
        return groups;
    }

    private static boolean shouldAdd(String name) {
        return Cfg.groupListed(name) && (!Cfg.modFamiliar(name) || Cfg.modEnabled(name));
    }

    public boolean modLoaded() {
        if (!this.mod.isPresent()) {
            return true;
        }
        String domain = this.mod.get();
        return !Cfg.modFamiliar(domain) || Cfg.modEnabled(domain);
    }

    public static PropertyGroup findOrCreate(String name) {
        return PropertyGroup.getHardCoded(name).orElseGet(() -> CommonMethods.find(Main.PROPERTY_GROUPS, g -> g.name.equals(name)).orElseGet(() -> new PropertyGroup(name, Collections.singleton(OreProperties.of(name).orElseThrow(() -> CommonMethods.runExF("No properties named \"{}.\" Fix your property group.", name))))));
    }

    private static Optional<PropertyGroup> getHardCoded(String name) {
        switch (name) {
            case "all": {
                return CommonMethods.full(ALL.get());
            }
            case "default": {
                return CommonMethods.full(DEFAULT.get());
            }
        }
        return CommonMethods.empty();
    }

    private static PropertyGroup getAllProperties() {
        return new PropertyGroup("all", new HashSet<OreProperties>(Main.ORE_PROPERTIES));
    }

    private static PropertyGroup getDefaultProperties() {
        HashSet<OreProperties> list = new HashSet<OreProperties>();
        for (DefaultInfo info : DefaultInfo.values()) {
            Optional<Set> updated = CommonMethods.find(Main.PROPERTY_GROUPS, g -> g.name.equals(info.name)).filter(PropertyGroup::modLoaded).map(group -> group.properties);
            updated.ifPresent(list::addAll);
        }
        return new PropertyGroup("default", list);
    }

    public static enum DefaultInfo implements ArrayTemplate<String>
    {
        MINECRAFT("coal", "diamond", "emerald", "gold", "iron", "lapis", "redstone"),
        ICEANDFIRE("sapphire", "silver"),
        SIMPLEORES("adamantium", "copper", "mythril", "tin"),
        BASEMETALS("antimony", "bismuth", "copper", "lead", "mercury", "nickel", "platinum", "silver", "tin", "zinc"),
        BIOMESOPLENTY("amber", "malachite", "peridot", "ruby", "sapphire", "tanzanite", "topaz"),
        GLASSHEARTS("agate", "amethyst", "opal", "ruby", "sapphire", "topaz"),
        THERMALFOUNDATION("copper", "lead", "nickel", "silver", "tin"),
        IMMERSIVEENGINEERING("aluminum", "copper", "lead", "nickel", "silver", "uranium"),
        EMBERS("aluminum", "copper", "lead", "nickel", "silver"),
        THAUMCRAFT("amber", "cinnabar"),
        MINERALOGY("phosphorous", "sulfur"),
        MODERNMETALS("aluminum", "beryllium", "boron", "cadmium", "chromium", "iridium", "magnesium", "osmium", "plutonium", "rutile", "tantalum", "thorium", "titanium", "tungsten", "uranium", "zirconium"),
        METALLURGY("copper", "deep_iron", "tin", "prometheum", "manganese", "oureclase", "infuscolium", "adamantine", "rubracium", "atlarus", "carmot", "mithril", "zinc", "orichalcum", "astral_silver", "silver", "platinum", "lutetium", "osmium", "sulfur", "phosphorite", "potash");

        private static final List<String> ADDITIONAL_NAMES;
        private final String[] values;
        private final String name = this.toString().toLowerCase();

        private DefaultInfo(String ... entries) {
            this.values = this.getNames(entries);
        }

        public static List<String> getAllNames() {
            ArrayList<String> names = new ArrayList<String>(ADDITIONAL_NAMES);
            for (DefaultInfo info : DefaultInfo.values()) {
                names.addAll(CommonMethods.list(info.values));
            }
            return names;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String[] getValues() {
            return this.values;
        }

        private String[] getNames(String[] entries) {
            ArrayList<String> names = new ArrayList<String>();
            for (String name : entries) {
                names.add(this.name.equals("minecraft") ? CommonMethods.f("{}_ore", name) : CommonMethods.f("{}_{}_ore", this.name, name));
            }
            return names.toArray(new String[0]);
        }

        static {
            ADDITIONAL_NAMES = CommonMethods.list("TUTORIAL", "quartz_ore", "quark_biotite_ore", "simpleores_onyx_ore", "basemetals_pewter_ore", "basemetals_adamantine_ore", "basemetals_coldiron_ore", "basemetals_cupronickel_ore", "basemetals_starsteel_ore", "thermalfoundation_aluminum_ore", "thermalfoundation_iridium_ore", "thermalfoundation_mithril_ore", "thermalfoundation_platinum_ore", "metallurgy_ignatius_ore", "metallurgy_shadow_iron_ore", "metallurgy_lemurite_ore", "metallurgy_midasium_ore", "metallurgy_vyroxeres_ore", "metallurgy_ceruclase_ore", "metallurgy_alduorite_ore", "metallurgy_kalendrite_ore", "metallurgy_vulcanite_ore", "metallurgy_sanguinite_ore", "metallurgy_eximite_ore", "metallurgy_meutoite_ore", "modernmetals_nichrome_ore", "modernmetals_galvanizedsteel_ore", "modernmetals_stainlesssteel_ore", "modernmetals_aluminumbrass_ore", "biomesoplenty_amethyst_ore");
        }
    }
}

