/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class SimpleModelBaker {
    private static final FaceBakery faceBakery = new FaceBakery();
    private static final Vector3f vecFrom = new Vector3f(-0.05f, -0.05f, -0.05f);
    private static final Vector3f vecTo = new Vector3f(16.05f, 16.05f, 16.05f);

    public IBakedModel bake(TextureAtlasSprite sprite, boolean shade) {
        HashMap<EnumFacing, List<BakedQuad>> quads = new HashMap<EnumFacing, List<BakedQuad>>();
        for (EnumFacing d : EnumFacing.values()) {
            BlockPartFace face = this.getFace(d);
            BlockPartRotation partRotation = this.getRotation(d);
            ModelRotation rotation = ModelRotation.X0_Y0;
            BakedQuad quad = faceBakery.func_178414_a(vecFrom, vecTo, face, sprite, d, rotation, partRotation, false, shade);
            quads.put(d, Collections.singletonList(quad));
        }
        return this.getSimpleModel(quads, sprite);
    }

    private BlockPartFace getFace(EnumFacing d) {
        BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        return new BlockPartFace(d, 0, "normal", uv);
    }

    private BlockPartRotation getRotation(EnumFacing d) {
        return new BlockPartRotation(vecFrom, d.func_176740_k(), 0.0f, false);
    }

    private IBakedModel getSimpleModel(Map<EnumFacing, List<BakedQuad>> quads, TextureAtlasSprite sprite) {
        return new SimpleBakedModel(new ArrayList(), quads, true, true, sprite, null, null);
    }
}

