/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.models;

import com.google.common.collect.ImmutableMap;
import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.io.ZipTools;
import com.personthecat.orestonevariants.models.OverlayBakedModel;
import com.personthecat.orestonevariants.models.SimpleModelBaker;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.textures.SpriteHandler;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.PathTools;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ModelEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (OreProperties props : Main.ORE_PROPERTIES) {
            ResourceLocation location = props.texture.overlayLocation;
            event.getMap().func_174942_a(location);
            event.getMap().func_174942_a(PathTools.ensureDense(location));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        Map<OreProperties, ModelPair> overlayGetter = ModelEventHandler.getOverlayModels();
        for (BaseOreVariant b : Main.BLOCKS) {
            IBakedModel bgModel = event.getModelManager().func_174953_a(ModelEventHandler.findModel(event, b.bgBlock));
            ModelPair overlays = overlayGetter.get(b.properties).onto(bgModel);
            ModelEventHandler.placeVariants(event, b.func_176223_P(), overlays);
        }
    }

    private static Map<OreProperties, ModelPair> getOverlayModels() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SimpleModelBaker baker = new SimpleModelBaker();
        for (OreProperties props : Main.ORE_PROPERTIES) {
            ResourceLocation location = props.texture.overlayLocation;
            TextureAtlasSprite normal = ModelEventHandler.getSprite(location);
            TextureAtlasSprite dense = ModelEventHandler.getSprite(PathTools.ensureDense(location));
            boolean shade = Cfg.shade(location);
            builder.put((Object)props, (Object)new ModelPair(baker.bake(normal, shade), baker.bake(dense, shade)));
        }
        return builder.build();
    }

    private static TextureAtlasSprite getSprite(ResourceLocation location) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    }

    private static ModelResourceLocation findModel(ModelBakeEvent event, IBlockState state) {
        ModelResourceLocation location = (ModelResourceLocation)event.getModelManager().func_174954_c().func_178120_a().func_188181_b(state.func_177230_c()).get(state);
        CommonMethods.info("Looking for {}; found: {}", state, location);
        return location;
    }

    private static void placeVariants(ModelBakeEvent event, IBlockState primary, ModelPair models) {
        IRegistry registry = event.getModelRegistry();
        BlockStateMapper mapper = event.getModelManager().func_174954_c().func_178120_a();
        mapper.func_188181_b(primary.func_177230_c()).forEach((state, location) -> {
            if (((Boolean)state.func_177229_b((IProperty)BaseOreVariant.DENSE)).booleanValue()) {
                registry.func_82595_a(location, (Object)models.dense);
            } else {
                registry.func_82595_a(location, (Object)models.normal);
            }
        });
        ResourceLocation normal = primary.func_177230_c().getRegistryName();
        registry.func_82595_a((Object)CommonMethods.mrl(normal, "inventory"), (Object)models.normal);
        registry.func_82595_a((Object)CommonMethods.mrl(CommonMethods.osvLocation("dense_" + normal.func_110623_a()), "inventory"), (Object)models.dense);
    }

    private static Set<IBlockState> getNormalStates(IBlockState state) {
        HashSet<IBlockState> states = new HashSet<IBlockState>();
        states.add(state.func_177230_c().func_176223_P());
        state.func_177228_b().keySet().stream().filter(property -> !property.equals(BaseOreVariant.DENSE)).map(property -> ModelEventHandler.getStatesFor(state, property)).forEach(states::addAll);
        return states;
    }

    private static <T extends Comparable<T>> Set<IBlockState> getStatesFor(IBlockState state, IProperty<T> property) {
        HashSet<IBlockState> states = new HashSet<IBlockState>();
        states.add(state);
        for (Comparable o : property.func_177700_c()) {
            state = state.func_177226_a(property, o);
            states.add(state);
        }
        return states;
    }

    @SideOnly(value=Side.CLIENT)
    public static void enableResourcePack() {
        SpriteHandler.defaultPacks.get().add((IResourcePack)new FileResourcePack(ZipTools.RESOURCE_PACK));
        Minecraft.func_71410_x().func_110436_a();
    }

    private static class ModelPair {
        private final IBakedModel normal;
        private final IBakedModel dense;

        private ModelPair(IBakedModel normal, IBakedModel dense) {
            this.normal = normal;
            this.dense = dense;
        }

        private ModelPair onto(IBakedModel background) {
            return new ModelPair(new OverlayBakedModel(background, this.normal), new OverlayBakedModel(background, this.dense));
        }
    }
}

