/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.item;

import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.LazyFunction;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class VariantItem
extends ItemBlock {
    private final LazyFunction<World, Optional<Advancement>> advancement = new LazyFunction(this::getAdvancement);

    public VariantItem(BaseOreVariant block) {
        this(block, block.getRegistryName());
    }

    private VariantItem(BaseOreVariant block, ResourceLocation name) {
        super((Block)block);
        this.setRegistryName(name);
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        this.advancement.apply(world).ifPresent(adv -> {
            if (entity instanceof EntityPlayerMP) {
                VariantItem.applyAdvancement((EntityPlayerMP)entity, adv);
            }
        });
    }

    private static void applyAdvancement(EntityPlayerMP player, Advancement advancement) {
        PlayerAdvancements playerAdvancements = player.func_192039_O();
        AdvancementProgress progress = playerAdvancements.func_192747_a(advancement);
        if (progress.func_192105_a()) {
            for (String criteria : progress.func_192107_d()) {
                playerAdvancements.func_192750_a(advancement, criteria);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState ore;
        StringBuilder name = new StringBuilder();
        if (stack.func_77960_j() > 0) {
            name.append(new TextComponentTranslation("osv.denseKey", new Object[0]).func_150254_d());
            name.append(" ");
        }
        if ((ore = ((BaseOreVariant)this.field_150939_a).properties.ore.get()).func_177230_c().func_149739_a().equals(this.field_150939_a.func_149739_a())) {
            name.append(CommonMethods.toStack(ore).func_82833_r());
        } else {
            name.append(this.field_150939_a.func_149732_F());
        }
        return name.append(" (").append(this.getBackgroundKey()).append(")").toString();
    }

    private String getBackgroundKey() {
        return CommonMethods.toStack(((BaseOreVariant)this.func_179223_d()).bgBlock).func_82833_r();
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    private Optional<Advancement> getAdvancement(World world) {
        return ((BaseOreVariant)this.field_150939_a).properties.advancement.filter(a -> Cfg.BlocksCat.enableAdvancements).flatMap(location -> CommonMethods.nullable(world.func_73046_m()).map(server -> server.func_191949_aK().func_192778_a(location)));
    }
}

