/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.io;

import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.unsafe.Result;
import com.personthecat.orestonevariants.util.unsafe.Void;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;

public class SafeFileIO {
    public static Result<Boolean, SecurityException> ensureDirExists(File file) {
        return Result.of(() -> file.exists() || file.mkdirs());
    }

    public static Result<Boolean, SecurityException> mkdirs(File file) {
        return Result.of(file::mkdirs);
    }

    public static boolean fileExists(File file, String err) {
        return Result.of(file::exists).expect(err);
    }

    public static Result<Path, IOException> copy(File file, File toDir) {
        return Result.of(() -> Files.copy(file.toPath(), new File(toDir, file.getName()).toPath(), new CopyOption[0]));
    }

    public static Result<File[], SecurityException> listFiles(File dir) {
        return Result.of(() -> dir.listFiles());
    }

    public static File[] safeListFiles(File dir) {
        return CommonMethods.nullable(dir.listFiles()).orElse(new File[0]);
    }

    public static Optional<List<String>> contents(File file) {
        return Result.of(() -> Files.readAllLines(file.toPath())).get(Result::IGNORE);
    }

    public static Result<Void, IOException> write(File file, String contents) {
        return Result.with(() -> new FileWriter(file)).of(tw -> tw.write(contents));
    }

    public static Result<File, IOException> moveReplace(File from, File to) {
        return Result.of(() -> {
            if (to.exists() || to.createNewFile()) {
                return Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING).toFile();
            }
            throw new IOException("Unable to find or create file: " + to.getPath());
        });
    }

    public static Result<Void, IOException> copyStream(InputStream input, OutputStream output, int bufferSize) {
        return Result.of(() -> {
            int length;
            byte[] buffer = new byte[bufferSize];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        });
    }

    public static Result<Void, IOException> copyStream(InputStream is, String path) {
        return Result.with(() -> new FileOutputStream(path)).of(o -> SafeFileIO.copyStream(is, o, 1024).throwIfErr());
    }

    public static Optional<InputStream> getResource(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return CommonMethods.nullable(SafeFileIO.class.getResourceAsStream(path));
    }

    public static InputStream getRequiredResource(String path) {
        return SafeFileIO.getResource(path).orElseThrow(() -> CommonMethods.runExF("The required file \"{}\" was not present in the jar.", path));
    }
}

