/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.init;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.blocks.BlockEntry;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.ExtendedResourceLocation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockInit {
    public static Set<BaseOreVariant> setupBlocks() {
        HashSet<BaseOreVariant> variants = new HashSet<BaseOreVariant>();
        for (BlockEntry entry : Main.BLOCK_ENTRIES) {
            for (IBlockState block : entry.blocks.blocks.get()) {
                for (OreProperties props : entry.properties.properties) {
                    if (!BlockInit.filterUBCVariants(props)) continue;
                    variants.add(BaseOreVariant.of(props, block));
                }
            }
        }
        return variants;
    }

    private static boolean filterUBCVariants(OreProperties properties) {
        if (Cfg.WorldCat.avoidDuplicateUBCVariants && Cfg.modEnabled("undergroundbiomes")) {
            ExtendedResourceLocation location = ExtendedResourceLocation.complete(properties.oreLookup);
            return !BlockInit.doesUBCSupport(location.func_110624_b());
        }
        return true;
    }

    private static boolean doesUBCSupport(String mod) {
        List<ResourceLocation> ubc = CommonMethods.findAll(ForgeRegistries.BLOCKS.getKeys(), l -> l.func_110624_b().equals("undergroundbiomes"));
        for (ResourceLocation location : ubc) {
            if (!location.func_110623_a().contains(mod)) continue;
            return true;
        }
        return false;
    }
}

