/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.config;

import com.personthecat.orestonevariants.blocks.BlockEntry;
import com.personthecat.orestonevariants.blocks.BlockGroup;
import com.personthecat.orestonevariants.config.ArrayTemplate;
import com.personthecat.orestonevariants.properties.PropertyGroup;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.Reference;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
@Config(modid="osv", category="")
public class Cfg {
    @Config.Ignore
    private static final File CONFIG_FILE = new File(CommonMethods.getConfigDir(), "osv.cfg");
    @Config.Ignore
    private static final Configuration CONFIG = Cfg.loadConfig(CONFIG_FILE);
    @Config.Ignore
    private static final Lazy<Set<String>> PROPERTIES = new Lazy<Supplier<Set>>(Cfg::getOreProperties);
    @Config.Ignore
    private static final Lazy<Set<String>> GROUPS = new Lazy<Supplier<Set>>(Cfg::getPropertyGroups);
    @Config.Ignore
    private static AtomicBoolean configChanged = new AtomicBoolean(false);
    @Config.LangKey(value="cfg.blocks")
    public static BlocksCat blocks;
    @Config.LangKey(value="cfg.dense")
    public static DenseCat dense;
    @Config.Comment(value={"  You can use this registry to add as many new ore types as you like using any", "background block at all. Block models, textures, world generation, and other", "properties are handled dynamically. These blocks will only spawn in whichever", "block or blockstate is listed as the background block. The ores retain a mixture", "of their original properties + those of their background.", "  The basic syntax is like this: \"<ore> <background>.\" For example, to spawn", "coal ore inside of sand, you would type \"coal_ore sand.\" Alternatively, you", "can list out any number of ore blocks inside of a new or existing PropertyGroup", "below and use its name in the place of \"<ore>.\" Likewise, \"<background>\" can", "be replaced with the name of a BlockGroup, as registered below.", "  Some block and property groups have special names. Those are \"all\" and", "\"default.\" Using \"all\" in the place of either will gather all of the respective", "entries from below and add them to the list dynamically. Using \"default\" in the", "place of either will gather all of the entries that are listed *by default*.", "  Any block listed in the place of \"<ore>\" must be registered using a preset", "located at \"./config/osv/ores/.\" You can add new presets there or modify existing", "presets to customize their properties. In the future, it will be possible to", "generate these presets dynamically, but they must be created manually for now."})
    @Config.LangKey(value="cfg.blockRegistry")
    public static BlockRegistryCat blockRegistry;
    @Config.LangKey(value="cfg.modSupport")
    public static ModSupport modSupport;
    @Config.LangKey(value="cfg.world")
    public static WorldCat world;

    private static Configuration loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        return config;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("osv")) {
            Cfg.sync();
        }
    }

    public static synchronized void sync() {
        ConfigManager.sync((String)"osv", (Config.Type)Config.Type.INSTANCE);
        configChanged.set(false);
    }

    public static synchronized void trySync() {
        if (configChanged.get()) {
            Cfg.sync();
        }
    }

    public static synchronized void configChanged() {
        configChanged.set(true);
    }

    public static boolean shade(ResourceLocation location) {
        String name = location.func_110623_a();
        boolean override = ArrayUtils.contains((Object[])BlocksCat.shadeOverrides, (Object)name);
        return BlocksCat.shadeOverlays != override;
    }

    public static boolean oreEnabled(String name) {
        return PROPERTIES.get().contains(name);
    }

    public static boolean groupListed(String name) {
        return GROUPS.get().contains(name);
    }

    public static boolean modEnabled(String mod) {
        if (mod.equals("minecraft")) {
            return Cfg.vanillaEnabled();
        }
        return CommonMethods.isModLoaded(mod) && ModSupport.enabledMods.get(mod) != false;
    }

    public static boolean modFamiliar(String mod) {
        return ModSupport.enabledMods.containsKey(mod);
    }

    public static boolean vanillaEnabled() {
        return !CommonMethods.anyMatches(BlocksCat.disableVanillaWhen, CommonMethods::isModLoaded);
    }

    private static Set<String> getOreProperties() {
        HashSet<String> properties = new HashSet<String>();
        for (String group : GROUPS.get()) {
            Optional<String[]> found = CommonMethods.safeGet(BlockRegistryCat.propertyGroups, group);
            found.map(Arrays::asList).ifPresent(properties::addAll);
            if (found.isPresent()) continue;
            properties.add(group);
        }
        return properties;
    }

    private static Set<String> getPropertyGroups() {
        Set<String> listed = Stream.of(BlockRegistryCat.values).map(entry -> BlockEntry.split(entry)[0]).collect(Collectors.toSet());
        if (listed.contains("all")) {
            listed.addAll(BlockRegistryCat.propertyGroups.keySet());
        } else if (listed.contains("default")) {
            BlockRegistryCat.propertyGroups.keySet().stream().filter(name -> Cfg.modFamiliar(name) && Cfg.modEnabled(name)).forEach(listed::add);
        }
        return listed;
    }

    private static Map<String, Boolean> getModSupport() {
        LinkedHashMap<String, Boolean> modSupport = new LinkedHashMap<String, Boolean>();
        for (String mod : Reference.SUPPORTED_MODS) {
            if (mod.equals("basemetals")) continue;
            Property prop = CONFIG.get("modSupport", mod, true);
            modSupport.put(mod, prop.getBoolean());
        }
        Property propBaseMetals = CONFIG.get("modSupport", "basemetals", true);
        propBaseMetals.setComment("For easiest compatibility with Base Metals, set both using_orespawn and\nfallback_orespawn to false in BaseMetals.cfg. Subsequently, disable\nOreSpawn itself. This is because both mods when combined will otherwise\nspawn twice as many ores as necessary.");
        modSupport.put("basemetals", propBaseMetals.getBoolean());
        return modSupport;
    }

    private static Map<String, String[]> handleDynamicGroup(String cat, ArrayTemplate<String> ... defaults) {
        ConfigCategory groups = CONFIG.hasCategory(cat) ? CONFIG.getCategory(cat) : new ConfigCategory(cat);
        for (ArrayTemplate<String> value : defaults) {
            Property p = new Property(value.getName(), value.getValues(), Property.Type.STRING);
            groups.putIfAbsent((Object)value.getName(), (Object)p);
        }
        return Cfg.castMap((Map<String, Property>)groups);
    }

    private static Map<String, String[]> castMap(Map<String, Property> map) {
        HashMap<String, String[]> cast = new HashMap<String, String[]>();
        map.forEach((k, v) -> cast.put((String)k, v.getStringList()));
        return cast;
    }

    static /* synthetic */ Map access$000(String x0, ArrayTemplate[] x1) {
        return Cfg.handleDynamicGroup(x0, x1);
    }

    static /* synthetic */ Map access$100() {
        return Cfg.getModSupport();
    }

    public static class WorldCat {
        @Config.Comment(value={"Whether to enable all OSV world gen features."})
        @Config.LangKey(value="cfg.world.generate")
        @Config.RequiresWorldRestart
        public static boolean enabled = true;
        @Config.Comment(value={"Whether ores should spawn according to specific biomes."})
        @Config.LangKey(value="cfg.world.biomeSpecific")
        @Config.RequiresWorldRestart
        public static boolean biomeSpecific = true;
        @Config.Comment(value={"Whether vanilla ores should spawn."})
        @Config.LangKey(value="cfg.world.enableVanillaOres")
        @Config.RequiresWorldRestart
        public static boolean enableVanillaOres = false;
        @Config.Comment(value={"Whether vanilla should spawn its own stone types."})
        @Config.LangKey(value="cfg.world.enableVanillaStone")
        @Config.RequiresWorldRestart
        public static boolean enableVanillaStone = false;
        @Config.Comment(value={"Whether OSV should spawn custom ore variants."})
        @Config.LangKey(value="cfg.world.enableOSVOres")
        @Config.RequiresWorldRestart
        public static boolean enableOSVOres = true;
        @Config.Comment(value={"Whether OSV should spawn custom stone veins."})
        @Config.LangKey(value="cfg.world.enableOSVStone")
        @Config.RequiresWorldRestart
        public static boolean enableOSVStone = true;
        @Config.Comment(value={"Ores will generate in larger veins, more often near other", "veins of the same type."})
        @Config.LangKey(value="cfg.world.largeClusters")
        @Config.RequiresMcRestart
        public static boolean largeClusters = false;
        @Config.Comment(value={"The probability that any ore will spawn outside of its selected", "regions."})
        @Config.LangKey(value="cfg.world.largeClusterDefaultProbability")
        @Config.RequiresMcRestart
        public static double largeClusterDefaultProbability = 0.01;
        @Config.Comment(value={"The maximum chance for ores to spawn in selected regions."})
        @Config.LangKey(value="cfg.world.largeClusterMaxProbability")
        @Config.RequiresMcRestart
        public static double largeClusterMaxProbability = 80.0;
        @Config.Comment(value={"Setting this to true will prevent OSV from spawning variants", "already generated by undergroundbiomes."})
        @Config.LangKey(value="cfg.world.avoidDuplicateUBCVariants")
        @Config.RequiresMcRestart
        public static boolean avoidDuplicateUBCVariants = true;
    }

    public static class ModSupport {
        @Config.Comment(value={"Set any of these to false to disable creation / spawning of new variants."})
        @Config.LangKey(value="cfg.modSupport.enabledMods")
        public static Map<String, Boolean> enabledMods = Cfg.access$100();
    }

    public static class BlockRegistryCat {
        @Config.LangKey(value="cfg.registry.values")
        public static String[] values = new String[]{"default default"};
        @Config.Comment(value={"Whether to test the block registry for duplicate combinations."})
        @Config.LangKey(value="cfg.registry.testForDuplicates")
        public static boolean testForDuplicates = true;
        @Config.Comment(value={"These categories are dynamic. You may create new lists here in order to conveniently", "reference them above."})
        @Config.LangKey(value="cfg.registry.blockGroups")
        public static Map<String, String[]> blockGroups = Cfg.access$000("blockRegistry.blockGroups", BlockGroup.DefaultInfo.values());
        @Config.LangKey(value="cfg.registry.propertyGroups")
        public static Map<String, String[]> propertyGroups = Cfg.access$000("blockRegistry.propertyGroups", PropertyGroup.DefaultInfo.values());
    }

    public static class DenseCat {
        @Config.Comment(value={"Adds a dense variant of every ore. Drops 1-3 x each original drop."})
        @Config.LangKey(value="cfg.dense.enable")
        @Config.RequiresMcRestart
        public static boolean enabled = false;
        @Config.Comment(value={"The 0-1 chance that dense ores will spawn instead of regular variants."})
        @Config.LangKey(value="cfg.dense.frequency")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresWorldRestart
        public static double chance = 0.09;
        @Config.LangKey(value="cfg.dense.smeltMultiplier")
        @Config.RequiresMcRestart
        public static int smeltMultiplier = 2;
        @Config.LangKey(value="cfg.dense.dropMultiplier")
        public static int dropMultiplier = 3;
        @Config.LangKey(value="cfg.dense.dropMultiplierMin")
        public static int dropMultiplierMin = 1;
        @Config.LangKey(value="cfg.dense.randomDropCount")
        @Config.Comment(value={"If true, dense variants drop a random number between 1 and multiplier."})
        public static boolean randomDropCount = true;
    }

    public static class BlocksCat {
        @Config.Comment(value={"Variants will imitate the properties of their background blocks,", "such as the ability to fall like sand or sustain leaves."})
        @Config.LangKey(value="cfg.blocks.bgImitation")
        @Config.RequiresMcRestart
        public static boolean bgImitation = true;
        @Config.Name(value="enableFurnaceRecipes")
        @Config.LangKey(value="cfg.blocks.enableFurnaceRecipes")
        @Config.RequiresMcRestart
        public static boolean enableFurnaceRecipes = true;
        @Config.LangKey(value="cfg.blocks.enableOreDictionary")
        @Config.RequiresMcRestart
        public static boolean enableOreDictionary = true;
        @Config.Comment(value={"Indicates whether to enable shading in the generated block models."})
        @Config.LangKey(value="cfg.blocks.shadeOverlays")
        public static boolean shadeOverlays = true;
        @Config.Comment(value={"Any model names listed here will be shaded or not, opposite of the", "global setting."})
        @Config.LangKey(value="cfg.blocks.shadeOverrides")
        public static String[] shadeOverrides = new String[0];
        @Config.Comment(value={"Whether textures should be rendered with support for a full range", "of opacity. You may want to disable this if you're using shaders."})
        @Config.LangKey(value="cfg.blocks.transparency")
        public static boolean translucentTextures = true;
        @Config.Comment(value={"Whether to attempt generating textures form the current resource packs."})
        @Config.LangKey(value="cfg.blocks.overlaysFromRP")
        public static boolean overlaysFromRP = true;
        @Config.LangKey(value="cfg.blocks.advancements")
        public static boolean enableAdvancements = true;
        @Config.Comment(value={"Vanilla ore variants will not be generated in the presence of any", "mods listed here."})
        @Config.LangKey(value="cfg.blocks.autoVanilla")
        @Config.RequiresMcRestart
        public static String[] disableVanillaWhen = new String[]{"mineralogy", "undergroundbiomes"};
        @Config.Comment(value={"Whether ore variants will drop instead of original counterparts."})
        @Config.LangKey(value="cfg.blocks.variantsDrop")
        public static boolean variantsDrop = false;
        @Config.Comment(value={"Whether ore variants will drop when using silk touch."})
        @Config.LangKey(value="cfg.blocks.variantsDropSilkTouch")
        public static boolean variantsSilktouch = true;
    }
}

