/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.blocks;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.config.ArrayTemplate;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.io.SafeFileIO;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.Lazy;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

public class BlockGroup {
    public final Lazy<Set<IBlockState>> blocks;
    public final Optional<String> mod;
    public final String name;
    public static final Lazy<BlockGroup> ALL = new Lazy<Supplier<BlockGroup>>(BlockGroup::getAllBlocks);
    public static final Lazy<BlockGroup> DEFAULT = new Lazy<Supplier<BlockGroup>>(BlockGroup::getDefaultBlocks);

    public BlockGroup(String name, Set<IBlockState> blocks) {
        this(name, blocks, CommonMethods.empty());
    }

    public BlockGroup(String name, Set<IBlockState> blocks, Optional<String> mod) {
        this(name, new Lazy<Set<IBlockState>>(blocks), mod);
    }

    private BlockGroup(String name, Lazy<Set<IBlockState>> blocks, Optional<String> mod) {
        this.name = name;
        this.blocks = blocks;
        this.mod = mod;
    }

    public static Set<BlockGroup> setupBlockGroups() {
        HashSet<BlockGroup> groups = new HashSet<BlockGroup>();
        Cfg.BlockRegistryCat.blockGroups.forEach((name, entries) -> {
            if (BlockGroup.shouldAdd(name)) {
                groups.add(new BlockGroup((String)name, (Lazy<Set<IBlockState>>)new Lazy<Supplier<Set>>(() -> BlockGroup.getStates(entries)), CommonMethods.empty()));
            }
        });
        return groups;
    }

    private static boolean shouldAdd(String name) {
        return !Cfg.modFamiliar(name) || Cfg.modEnabled(name);
    }

    private static Set<IBlockState> getStates(String ... entries) {
        return Stream.of(entries).map(entry -> CommonMethods.getBlockState(entry).orElseThrow(() -> CommonMethods.runExF("There is no block named \"{}.\" Fix your block group.", entry))).collect(Collectors.toSet());
    }

    private static BlockGroup getAllBlocks() {
        Lazy<Supplier<Set>> lazyBlocks = new Lazy<Supplier<Set>>(() -> {
            HashSet blocks = new HashSet();
            for (BlockGroup group : Main.BLOCK_GROUPS) {
                blocks.addAll(group.blocks.get());
            }
            return blocks;
        });
        return new BlockGroup("all", lazyBlocks, CommonMethods.empty());
    }

    private static BlockGroup getDefaultBlocks() {
        Lazy<Supplier<Set>> lazyBlocks = new Lazy<Supplier<Set>>(() -> {
            HashSet blocks = new HashSet();
            for (DefaultInfo info : DefaultInfo.values()) {
                Set updated = CommonMethods.find(Main.BLOCK_GROUPS, g -> g.name.equals(info.getName())).map(group -> group.blocks.get()).orElseGet(Collections::emptySet);
                blocks.addAll(updated);
            }
            return blocks;
        });
        return new BlockGroup("default", lazyBlocks, CommonMethods.empty());
    }

    public static BlockGroup findOrCreate(String name) {
        return BlockGroup.getHardCoded(name).orElseGet(() -> CommonMethods.find(Main.BLOCK_GROUPS, g -> g.name.equals(name)).orElseGet(() -> new BlockGroup(name, Collections.singleton(CommonMethods.getBlockState(name).orElseThrow(() -> CommonMethods.runExF("No block named \"{}.\" Fix your block group.", name))))));
    }

    private static Optional<BlockGroup> getHardCoded(String name) {
        switch (name) {
            case "all": {
                return CommonMethods.full(ALL.get());
            }
            case "default": {
                return CommonMethods.full(DEFAULT.get());
            }
        }
        return CommonMethods.empty();
    }

    public int size() {
        return this.blocks.get().size();
    }

    public static enum DefaultInfo implements ArrayTemplate<String>
    {
        MINECRAFT("stone", "andesite", "diorite", "granite"),
        EARTHWORKS("block_chalk", "block_slate", "block_slate_green", "block_slate_purple"),
        MINERALOGY("amphibolite", "andesite", "basalt", "chert", "conglomerate", "diorite", "dolomite", "granite", "gypsum", "limestone", "marble", "pegmatite", "phyllite", "pumice", "rhyolite", "schist"),
        QUARK("limestone", "marble", "slate", "jasper"),
        RUSTIC("slate"),
        UNDERGROUNDBIOMES("igneous_stone:0", "igneous_stone:1", "igneous_stone:2", "igneous_stone:3", "igneous_stone:4", "igneous_stone:5", "igneous_stone:6", "igneous_stone:7", "metamorphic_stone:0", "metamorphic_stone:1", "metamorphic_stone:2", "metamorphic_stone:3", "metamorphic_stone:4", "metamorphic_stone:5", "metamorphic_stone:6", "metamorphic_stone:7", "sedimentary_stone:0", "sedimentary_stone:1", "sedimentary_stone:2", "sedimentary_stone:3", "sedimentary_stone:4", "sedimentary_stone:5", "sedimentary_stone:6", "sedimentary_stone:7");

        private final String[] values;
        private final String[] names;
        private final String name = this.toString().toLowerCase();

        private DefaultInfo(String ... entries) {
            this.names = entries;
            this.values = this.getValues(entries);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String[] getValues() {
            return this.values;
        }

        public String[] getNames() {
            return this.names;
        }

        private String[] getValues(String[] entries) {
            ArrayList<String> names = new ArrayList<String>();
            for (String entry : entries) {
                StringBuilder sb = new StringBuilder();
                if (this.name.equals("minecraft")) {
                    String location = DefaultInfo.getLocation(entry);
                    sb.append(location);
                } else {
                    sb.append(this.name);
                    sb.append(':');
                    sb.append(entry);
                }
                names.add(sb.toString());
            }
            return names.toArray(new String[0]);
        }

        private static String getLocation(String entry) {
            if (entry.equals("stone")) {
                return entry;
            }
            String path = CommonMethods.f("assets{}{}.hjson", "/osv/stone/", entry);
            InputStream is = SafeFileIO.getRequiredResource(path);
            JsonObject json = HjsonTools.readJson(is).orElseThrow(() -> CommonMethods.runExF("Expected {}.json to exist in jar.", entry));
            return (String)HjsonTools.getObject(json, "block").flatMap(o -> HjsonTools.getString(o, "location")).orElseThrow(() -> CommonMethods.runEx("Missing field bundled preset."));
        }
    }
}

