/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants;

import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.blocks.BlockEntry;
import com.personthecat.orestonevariants.blocks.BlockGroup;
import com.personthecat.orestonevariants.commands.CommandOSV;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.init.BlockInit;
import com.personthecat.orestonevariants.init.ItemInit;
import com.personthecat.orestonevariants.io.JarFiles;
import com.personthecat.orestonevariants.io.ZipTools;
import com.personthecat.orestonevariants.properties.OreProperties;
import com.personthecat.orestonevariants.properties.PropertyGroup;
import com.personthecat.orestonevariants.properties.StoneProperties;
import com.personthecat.orestonevariants.proxy.CommonProxy;
import com.personthecat.orestonevariants.recipes.RecipeHelper;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.SafeRegistry;
import com.personthecat.orestonevariants.world.DisableVanillaGen;
import com.personthecat.orestonevariants.world.OreGen;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="osv", name="Ore Stone Variants", version="5.14", dependencies="after:*", acceptedMinecraftVersions="[1.12.2]")
public class Main {
    @Mod.Instance
    public static Main instance;
    public static final String MODID = "osv";
    public static final Logger LOGGER;
    public static final Set<Item> ITEMS;
    public static final Set<BaseOreVariant> BLOCKS;
    public static final Set<BlockGroup> BLOCK_GROUPS;
    public static final Set<OreProperties> ORE_PROPERTIES;
    public static final Set<StoneProperties> STONE_PROPERTIES;
    public static final Set<PropertyGroup> PROPERTY_GROUPS;
    public static final Set<BlockEntry> BLOCK_ENTRIES;
    @SidedProxy(clientSide="com.personthecat.orestonevariants.proxy.ClientProxy", serverSide="com.personthecat.orestonevariants.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ZipTools.copyResourcePack();
        JarFiles.copyPresetFiles();
        proxy.generateOverlays();
        proxy.enableResourcePack();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        RecipeHelper.handleRecipes();
        if (Cfg.WorldCat.enabled) {
            Main.enableWorldGen();
        }
    }

    @Mod.EventHandler
    public static void serverInit(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandOSV());
    }

    private static void enableWorldGen() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGen(), (int)Integer.MAX_VALUE);
        MinecraftForge.ORE_GEN_BUS.register(DisableVanillaGen.class);
    }

    static {
        LOGGER = CommonMethods.logger(MODID);
        ITEMS = SafeRegistry.of(ItemInit::setupItems);
        BLOCKS = SafeRegistry.of(BlockInit::setupBlocks);
        BLOCK_GROUPS = SafeRegistry.of(BlockGroup::setupBlockGroups);
        ORE_PROPERTIES = SafeRegistry.of(OreProperties::setupOreProperties);
        STONE_PROPERTIES = SafeRegistry.of(StoneProperties::setupStoneProperties);
        PROPERTY_GROUPS = SafeRegistry.of(PropertyGroup::setupPropertyGroups);
        BLOCK_ENTRIES = SafeRegistry.of(BlockEntry::setupEntries);
    }
}

