/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.superckl.api.biometweaker.world.gen.feature.WorldGeneratorWrapper;
import me.superckl.biometweaker.common.world.gen.PlacementStage;

public class DecorationManager {
    private static final TIntObjectMap<DecorationManager> managers = new TIntObjectHashMap();
    private static PlacementStage defaultStage = PlacementStage.POST_DECORATE;
    private static final Map<PlacementStage, TIntObjectMap<List<WorldGeneratorWrapper<?>>>> globalGenerators = new EnumMap(PlacementStage.class);
    private final Map<PlacementStage, TIntObjectMap<List<WorldGeneratorWrapper<?>>>> generators = new EnumMap(PlacementStage.class);
    private static PlacementStage currentStage = defaultStage;

    public static DecorationManager getManagerForWorld(int worldId) {
        DecorationManager manager = (DecorationManager)managers.get(worldId);
        if (manager == null) {
            manager = new DecorationManager();
            managers.put(worldId, (Object)manager);
        }
        return manager;
    }

    public static boolean hasGlobalReplacements() {
        return !globalGenerators.isEmpty();
    }

    public boolean hasReplacements() {
        return DecorationManager.hasGlobalReplacements() || !this.generators.isEmpty();
    }

    public boolean hasReplacements(PlacementStage stage) {
        if (!this.hasReplacements()) {
            return false;
        }
        TIntObjectMap<List<WorldGeneratorWrapper<?>>> entries = globalGenerators.get((Object)stage);
        if (entries == null || entries.isEmpty()) {
            TIntObjectMap<List<WorldGeneratorWrapper<?>>> localEntries = this.generators.get((Object)stage);
            return localEntries != null && !localEntries.isEmpty();
        }
        return entries != null && !entries.isEmpty();
    }

    public boolean hasReplacements(int biome, PlacementStage stage) {
        if (!this.hasReplacements()) {
            return false;
        }
        TIntObjectMap<List<WorldGeneratorWrapper<?>>> entries = globalGenerators.get((Object)stage);
        if (entries == null || !entries.containsKey(biome)) {
            TIntObjectMap<List<WorldGeneratorWrapper<?>>> localEntries = this.generators.get((Object)stage);
            return localEntries != null && localEntries.containsKey(biome);
        }
        return entries != null && entries.containsKey(biome);
    }

    public void registerDecoration(int biome, WorldGeneratorWrapper<?> generator) {
        if (!this.generators.containsKey((Object)currentStage)) {
            this.generators.put(currentStage, (TIntObjectMap<List<WorldGeneratorWrapper<?>>>)new TIntObjectHashMap());
        }
        if (!this.generators.get((Object)currentStage).containsKey(biome)) {
            this.generators.get((Object)currentStage).put(biome, new ArrayList());
        }
        ((List)this.generators.get((Object)currentStage).get(biome)).add(generator);
    }

    public static void registerGlobalDecoration(int biome, WorldGeneratorWrapper<?> gen) {
        if (!globalGenerators.containsKey((Object)currentStage)) {
            globalGenerators.put(currentStage, (TIntObjectMap<List<WorldGeneratorWrapper<?>>>)new TIntObjectHashMap());
        }
        if (!globalGenerators.get((Object)currentStage).containsKey(biome)) {
            globalGenerators.get((Object)currentStage).put(biome, new ArrayList());
        }
        ((List)globalGenerators.get((Object)currentStage).get(biome)).add(gen);
    }

    @Nullable
    public List<WorldGeneratorWrapper<?>> findDecorationList(int biome, PlacementStage stage) {
        TIntObjectMap<List<WorldGeneratorWrapper<?>>> entryMap = this.generators.get((Object)stage);
        if (entryMap != null) {
            return (List)entryMap.get(biome);
        }
        entryMap = globalGenerators.get((Object)stage);
        if (entryMap != null) {
            return (List)entryMap.get(biome);
        }
        return null;
    }

    public static PlacementStage getDefaultStage() {
        return defaultStage;
    }

    public static PlacementStage getCurrentStage() {
        return currentStage;
    }

    public static void setCurrentStage(PlacementStage currentStage) {
        DecorationManager.currentStage = currentStage;
    }
}

